class Residential : Default
{
	zombieChance = 0.3;
	maxRoaming = 2;
	zombieClass[] =
	{
		"zZombie_Base",
		"z_hunter",
		"z_teacher",
		"z_villager1",
		"z_villager2",
		"z_villager3"
	};
	lootChance = 0.5;
	lootGroup = Residential;
};

class Land_HouseV_1I4 : Residential
{
	zedPos[] = {{-0.400146,-3.87891,-2.7688},{-3.67651,-2.51758,-2.76544},{-0.472412,3.19824,-2.72028}};
	lootPos[] = {
		//{0.53,-4.53,-2.77},{-3.83,-2.5,-2.77},{-0.51,3.92,-2.72},{-1.93,-5.12,-2.17},{0.57,-1.53,-2.76},
		{0.222168,3.90839,-2.73031},{-1.82983,-1.81403,-2.76768}
	};
	lootPosSmall[] = {
		{-1.91772,-5.13812,-2.14811},{-4.34497,-1.12036,-1.88536},{-2.12329,-2.59363,-2.05582},{-1.34595,-2.80969,-2.04825}
	};
};

class Land_kulna : Residential
{
	zedPos[] = {{-0.498291,1.92871,-1.12811},{0.503174,0.217773,-1.11633}};
	//lootPos[] = {{0.503174,0.217773,-1.11633},{-0.498291,1.92871,-1.12811}};
	lootPos[] = {{0.213379,1.49707,-1.14344}};
};

class Land_hut06 : Residential
{
	zedPos[] = {{0.337402,2.27051,-1.56116},{-0.637695,0.753906,-1.53836}};
	//lootPos[] = {{0.337402,2.27051,-1.56116},{-0.637695,0.753906,-1.53836}};
	lootPos[] = {{0.328125,2.26953,-1.57786},{-0.552368,-0.0620117,-1.53837}};
};

class Land_Hlidac_budka : Residential
{
	zedPos[] = {{2.02051,0.444336,-0.81366},{-0.460938,1.75879,-0.78363},{-2.31836,1.5127,-0.78363}};
	lootPos[] = {
		//{-2.31836,1.5127,-0.78363},{2.02051,0.444336,-0.81366},{-0.460938,1.75879,-0.78363},
		{2.4209,2.16064,-0.783617}
	};
	lootPosSmall[] = {
		{0.987305,2.43359,-0.113617},{1.67773,2.24927,-0.113617},{-0.138184,0.0844727,-0.713617}
	};
};

class Land_HouseV2_02_Interier : Residential
{
	zedPos[] = {{-3.62598,3.05273,-5.58072},{3.34814,1.9707,-5.57071},{5.20117,-1.54004,-5.57071},{-5.71094,5.49414,-5.57071},{7.23145,5.37109,-5.57071},{-7.57861,-1.01563,-5.57071},{8.5498,0.754883,-5.57071},{-6.52295,2.35547,-5.5607}};
	lootPos[] = {
		//{7.23,5.37,-5.57},{8.55,0.75,-5.57},{5.2,-1.54,-5.57},{3.35,1.97,-5.57},{-3.63,3.05,-5.58},{-7.58,-1.02,-5.57},{-6.52,2.35,-5.56},{-5.71,5.49,-5.57},{6.53,1.49,-4.64},{0.05,1.32,-5.53},
		{6.97412,1.26904,-5.53068},{4.21631,6.56396,-5.53068},{-5.94922,-1.28955,-5.53068},{-3.31494,6.44287,-5.53068}
	};
	lootPosSmall[] = {
		{6.44629,1.7251,-4.61068},{6.63672,1.2583,-4.61068},{8.7749,-2.23779,-4.74068},{2.81006,6.30908,-5.57068},{-4.97754,-2.1543,-5.57068},{-2.42676,5.58887,-5.57068}
	};
};

class Land_A_Pub_01 : Residential
{
	zombieChance = 0.2;
	lootPos[] = {
		//{1.83,0.39,-5.75},{-1.77,0.33,-5.76},{-6.66,-6.43,-5.76},{-4.64,-0.1,-5.75},{-5.76,-3.05,-5.75},{-2.08,0.92,-1.79},{-4.77,-5.89,-1.78},{-6.94,-1.94,-1.77},{-4.05,-0.78,-1.78},{1.4,-1.74,-1.76},{3.14,-2.79,-1.76},{3.58,-0.59,-1.76},{3.03,-4.04,-1.76},{1.94,3.19,-1.78},{-0.1,6.22,-1.78},{5.3,7.56,-1.79},{6.93,-2.85,-1.79},{2.57,-4.6,-5.76},{4.07,5.41,-5.76},{0.75,2.3,-5.75},{6.47,-1.71,-5.06},
		{1.17188,5.7522,-5.75623},{6.46191,-1.73706,-5.01623},{6.46777,1.47949,-5.75623},{0.975098,-5.80859,-5.75621},{-5.79736,-2.57813,-1.79123},{-7.35303,-3.7627,-1.79123},{4.56885,0.998291,-1.79123},{3.45947,0.236328,-1.79123},{1.91504,6.302,-1.79123},{0.114258,2.17432,-1.79123},{6.52832,6.10889,-1.79123},{0.555176,0.169189,-1.79123},{-4.37793,-2.64038,-5.75623},{-7.1709,-1.76855,-5.75623}
	};
	lootPosSmall[] = {
		{-0.602051,2.69214,-5.48623},{2.0708,1.98486,-5.19622},{1.37744,7.89722,-5.01622},{3.28076,-1.51782,-4.75623},{2.79395,-1.90845,-4.75622},{1.19043,-1.97632,-4.7562},{4.03418,-5.81592,-5.30621},{1.46143,-6.27979,-5.01621},{-4.8252,-2.66309,-1.78122},{1.16504,1.125,-1.19122},{2.73486,0.744873,-0.701225},{5.04053,-2.60938,-1.78122},{5.00293,2.03491,-1.78122},{2.89844,5.78613,-1.37122},{1.44482,6.51831,-1.31123},{1.77734,7.88013,-1.79123},{5.81934,5.90967,-1.41122},{-3.41016,1.26123,-1.78123},{-7.37891,-1.24756,-5.28622}
	};
	zedPos[] = {{-1.76563,0.334473,-5.75623},{2.56934,-4.6001,-5.75623},{4.06738,5.41406,-5.75623},{-6.66211,-6.4292,-5.75623},{0.75293,2.2998,-5.74622},{-4.63574,-0.100586,-5.74622},{-5.75977,-3.05029,-5.74622},{1.83398,0.394043,-5.74619},{-2.08203,0.922852,-1.79126},{5.30469,7.55957,-1.79126},{6.93164,-2.84668,-1.79126},{-0.0957031,6.22461,-1.78125},{1.94141,3.18799,-1.78125},{-4.05273,-0.779785,-1.78125},{-4.76563,-5.89111,-1.78125},{-6.94434,-1.9375,-1.77124},{1.39844,-1.73779,-1.76123},{3.03027,-4.04346,-1.76123},{3.13867,-2.78564,-1.76123},{3.58301,-0.591309,-1.76123}};
};

class Land_Shed_wooden : Residential
{
	zedPos[] = {{-0.342773,1.0293,-1.29156},{1.26807,-0.362305,-1.29156}};
	//lootPos[] = {{1.26807,-0.362305,-1.29156},{-0.342773,1.0293,-1.29156}};
	lootPos[] = {{1.26807,-0.361328,-1.29153},{-0.342773,1.0293,-1.29153}};
};

class Land_HouseBlock_A1_1 : Residential
{
	zedPos[] = {{-3.52881,0.15918,-4.74365},{-3.56152,-2.33496,-4.73096}};
	//lootPos[] = {{-3.52881,0.15918,-4.74365},{-3.56152,-2.33496,-4.73096}};
	lootPos[] = {{-3.52881,0.158936,-4.74365},{-3.56152,-2.33484,-4.73106}};
};

class Land_HouseV_1I1 : Residential
{
	zedPos[] = {{0.100586,-2.34473,-2.88281}};
	//lootPos[] = {{0.100586,-2.34473,-2.88281}};
	lootPosSmall[] = {{0.728516,-2.01514,-2.86235}};
};

class Land_A_MunicipalOffice : Residential
{
	maxRoaming = 3;
	zedPos[] = {{-0.20752,-6.48633,-18.429},{3.31641,-5.77441,-18.429},{-4.66113,-6.27246,-18.429}};
	lootChance = 0.4;
	lootPos[] = {
		//{-4.66113,-6.27246,-18.429},{3.31641,-5.77441,-18.429},{-0.20752,-6.48633,-18.429},{-9.72412,-4.8877,-3.759},{-9.57813,3.55566,-3.759},{-7.17285,11.083,-3.76901},{5.06934,11.1836,-3.74899},{9.3208,5.38574,-3.76901},{9.65283,-4.82129,-3.74899},{3.23535,-0.106445,-0.169037},{4.85156,-3.69043,-0.169037},{-0.80127,-7.88184,-0.169037},{-4.4082,-4.91797,-0.169037},{-4.90771,-2.23145,-0.169037},
		{-4.66113,-6.27173,-18.429},{3.31641,-5.77417,-18.429},{-0.20752,-6.48682,-18.429},{-9.72412,-4.88745,-3.78903},{-9.57813,3.55615,-3.78903},{-7.16797,11.0737,-3.78903},{5.07422,11.1838,-3.78903},{9.3208,5.38623,-3.78903},{9.65332,-4.82056,-3.78903},{3.23535,-0.105957,-0.169027},{4.85205,-3.69019,-0.169027},{-0.80127,-7.89087,-0.169027},{-4.4082,-4.91772,-0.169027},{-4.90771,-2.23169,-0.169027}
	};
	lootPosSmall[] = {
		{4.34521,-8.81567,-18.439},{-1.06787,-5.11499,-18.439},{1.3291,9.86938,-18.4413},{-1.54395,9.90649,-18.4353}
	};
};

class Land_HouseV2_04_interier : Residential
{
	zedPos[] = {{2.10938,6.60449,-5.76862},{-2.30029,4.22461,-5.75937},{-4.96289,2.91309,-5.74985},{1.95557,4.16211,-5.74939},{-5.13281,6.74316,-5.74857},{7.51025,-0.931641,-5.74176},{7.49561,5.83594,-5.73901}};
	lootPos[] = {
		//{7.5,6.93,-5.74},{7.58,-1.89,-5.74},{1.85,2.66,-5.06},{3.38,6.4,-5.77},{-1.44,3.1,-5.76},{-3.63,6.88,-4.99},{-4.96,2.91,-5.75},{0.29,1.26,-2.93},{-1.44,6.44,-5.74},{4.82,2.63,-5.74},
		{-5.08826,3.13818,-5.73971},{7.37061,6.52881,-5.73873},{1.75281,3.70752,-5.73953},{-3.75183,7.1626,-5.73842},{0.292725,1.27441,-2.93809}
	};
	lootPosSmall[] = {
		{4.7594,2.8042,-5.07979},{4.93396,2.56348,-5.07979},{1.95215,2.67529,-5.05956},{0.668823,2.56299,-5.74944},{-3.7146,7.07813,-4.98862},{-3.31897,6.68457,-4.98895},{-2.87244,6.92676,-5.29893},{-3.95215,2.85449,-5.19935}
	};
};

class Land_HouseV2_01A : Residential
{
	zedPos[] = {{-1.60547,-3.23535,-5.61884},{-3.37256,-3.34082,-5.58344}};
	//lootPos[] = {{-3.37256,-3.34082,-5.58344},{-1.60547,-3.23535,-5.61884}};
	lootPosSmall[] = {{-3.53906,-3.29736,-5.55779},{-0.759766,-3.95068,-5.56563}};
};

class Land_psi_bouda : Residential
{
	zombieChance = 0;
	maxRoaming = 0;
	zedPos[] = {{1.02197,0.0185547,-0.519989}};
	lootPos[] = {{1.02197,0.0185547,-0.519989}};
};

class Land_KBud : Residential
{
	zombieChance = 0.3;
	maxRoaming = 0;
	zedPos[] = {{-0.017334,0.0107422,-0.663696}};
	//lootPos[] = {{-0.017334,0.0107422,-0.663696}};
	lootPos[] = {{-0.0170898,0.0114746,-0.66367}};
};

class Land_sara_domek_zluty : Residential
{
	maxRoaming = 1;
	zedPos[] = {{-6.17139,-2.33789,-2.43384},{-0.660645,2.05469,-2.43372},{6.36401,-0.236328,-2.43372},{2.95679,3.00684,-2.43365},{-3.75342,-3.54785,-2.42389},{-2.77441,0.751953,-2.42371},{-5.07666,3.04395,-2.42352},{0.627197,-0.584961,-2.41394},{7.06665,2.9541,-2.4137}};
	lootPos[] = {
		//{2.96,3.01,-2.43},{7.07,2.95,-2.41},{6.36,-0.24,-2.43},{0.63,-0.58,-2.44},{-0.66,2.05,-2.43},{-2.77,0.75,-2.42},{-5.08,3.04,-2.42},{-6.17,-2.34,-2.43},{-3.75,-3.55,-2.42},
		{6.91724,3.09277,-2.43372},{6.52881,-0.521973,-2.43379},{0.613037,3.74463,-2.4337},{-7.00024,-0.744141,-2.43373},{-3.13672,3.45459,-2.43364},{-6.81055,-2.67676,-2.43385}
	};
	lootPosSmall[] = {
		{7.26685,-0.882324,-2.43378},{4.00684,3.84766,-2.43372},{-1.11255,1.29395,-2.43382},{-7.22192,-4.23584,-2.43386}
	};
};

class Land_HouseV_3I4 : Residential
{
	maxRoaming = 3;
	zedPos[] = {{5.46387,2.80273,-2.61298}};
	lootPos[] = {{5.46387,2.80273,-2.61298}};
};

class Land_Shed_W4 : Residential
{
	maxRoaming = 3;
	zedPos[] = {};
	lootPos[] = {};
};

class Land_HouseV_3I1 : Residential
{
	maxRoaming = 3;
	zedPos[] = {};
	lootPos[] = {};
};

class Land_HouseV_1L2 : Residential
{
	maxRoaming = 3;
	zedPos[] = {{-0.448242,5.29883,-3.01697}};
	lootPos[] = {
		//{-0.448242,5.29883,-3.01697}
		{-2.58887,-4.8584,-0.789368},{-2.58887,-4.8584,-0.789368},{-2.37646,0.373047,-0.799377}
	};
	lootPosSmall[] = {
		{-1.37354,-3.26465,-0.789368},{4.48389,-3.06348,0.0406189},{4.53271,-3.61328,0.590637},{-1.37354,-3.26465,-0.789368},{4.48389,-3.06348,0.0406189},{4.53271,-3.61328,0.590637},{4.29126,-1.02441,0.0606384},{-0.199707,3.28711,-2.9292}
	};
};

class Land_HouseV_1T : Residential
{
	maxRoaming = 3;
	zedPos[] = {{2.53027,-2.41895,-3.22815}};
	lootPos[] = {{2.53027,-2.41895,-3.22815}};
};

class Land_HouseV_1L1 : Residential
{
	zedPos[] = {{1.20801,5.86035,-1.09302}};
	lootPos[] = {{1.20801,5.86035,-1.09302}};
};

class Land_HouseV_1I2 : Residential
{
	zedPos[] = {{-3.60205,2.81641,-2.23148}};
	lootPos[] = {{-3.60205,2.81641,-2.23148}};
};

class Land_HouseV_2L : Residential
{
	zedPos[] = {{-3.98438,-3.87207,-4.02338},{4.32617,1.81836,-3.96332}};
	//lootPos[] = {{4.32617,1.81836,-3.96332},{-3.98438,-3.87207,-4.02338}};
	lootPosSmall[] = {{4.39404,1.28296,-3.96535},{4.12988,2.52222,-3.95569}};
};

class Land_HouseV_1I3 : Residential
{
	zedPos[] = {{2.19531,-0.954102,-2.23218}};
	lootPos[] = {{2.19531,-0.954102,-2.23218}};
};

class Land_houseV_2T2 : Residential
{
	zedPos[] = {{-4.24951,0.988281,-4.0574}};
	lootPos[] = {
		//{-4.24951,0.988281,-4.0574},
		{-3.49072,1.01782,-4.03519}
	};
	lootPosSmall[] = {
		{2.8606,4.33081,-4.65974},
		{-0.222778,4.34985,-4.65713}
	};
};

class Land_HouseBlock_A1 : Residential
{
	zedPos[] = {{-3.48242,2.13965,-8.81882},{-4.56689,-3,-8.81262}};
	lootPos[] = {{-4.56689,-3,-8.81262},{-3.48242,2.13965,-8.81882}};
};

class Land_HouseBlock_A2_1 : Residential
{
	zedPos[] = {{3.98975,4.48926,-7.4043}};
	lootPos[] = {{3.98975,4.48926,-7.4043}};
};

class Land_HouseBlock_A3 : Residential
{
	zedPos[] = {{0.554688,2.70801,-5.4317}};
	lootPos[] = {{0.56,2.71,-5.43},{-0.72,-3.61,-5.45},{1.04,-1.56,-5.45}};
};

class Land_HouseBlock_B5 : Residential
{
	zedPos[] = {{-5.10742,5.23926,-7.57431}};
	lootPos[] = {{-5.10742,5.23926,-7.57431}};
};

class Land_HouseBlock_B6 : Residential
{
	zedPos[] = {{-3.01172,0.820313,-7.60886}};
	lootPos[] = {{-3.01172,0.820313,-7.60886}};
};

class Land_HouseBlock_C1 : Residential
{
	zedPos[] = {{5.85889,4.46875,-9.59036}};
	lootPos[] = {{5.85889,4.46875,-9.59036}};
};

class Land_HouseV2_01B : Residential
{
	zedPos[] = {{9.53711,3.39453,-6.11053}};
	//lootPos[] = {{9.53711,3.39453,-6.11053}};
	lootPosSmall[] = {{-4.27881,-2.22852,-5.18173}};
};

class Land_HouseV2_03 : Residential
{
	zedPos[] = {{0.812988,7.99805,-5.89618},{9.96143,-9.00488,-5.48578}};
	lootPos[] = {{0.812988,7.99805,-5.89618},{9.96143,-9.00488,-5.48578}};
};
/*
class Land_Mil_Guardhouse : Residential //MOVED TO MIL
{
	maxRoaming = 3;
	zedPos[] = {{-2.44727,0.250977,-1.70563},{-2.44873,3.00293,-1.70285}};
	lootPos[] = {{-2.44727,0.250977,-1.70563},{-2.44873,3.00293,-1.70285}};
};
*/
class LADAWreck : Residential
{
	maxRoaming = 0;
	zedPos[] = {};
	lootChance = 0.2;
	lootPos[] = {{-0.106934,-0.660156,-0.144714}};
};

class SKODAWreck : Residential
{
	maxRoaming = 0;
	zedPos[] = {};
	lootChance = 0.2;
	lootPos[] = {{-0.66,-0.09,-0.58}};
};

class Land_GuardShed : Residential
{
	maxRoaming = 1;
	zedPos[] = {{-0.02,-1,-0.61}};
	lootPos[] = {{-0.02,-1,-0.61}};
};

class RU_WarfareBBarracks : Residential
{
	maxRoaming = 0;
	zedPos[] = {{2.06,-2.63,0.52},{-0.01,2.35,0.55},{2.43,2.04,1.08},{-2.81,2.49,1.3},{-0.72,-0.03,1.31},{-0.38,-2.29,1.87}};
	lootChance = 0.1;
	lootPos[] = {{-2.81,2.49,1.3},{-0.72,-0.03,1.31},{2.06,-2.63,0.52},{-0.38,-2.29,1.87},{2.43,2.04,1.08},{-0.01,2.35,0.55}};
};

class Land_NAV_Lighthouse : Residential
{
	zedPos[] = {{-0.16,-0.1,-6.78},{-0.06,3.36,-7.87}};
	lootChance = 0.4;
	lootPos[] = {{-0.16,-0.1,-6.78},{0.01,-1.7,2.42},{-0.06,3.36,-7.87}};
};

class Land_Panelak3 : Residential
{
	zedPos[] = {};
	//lootPos[]={{0.54,-0.71,-8.11},{2.51,-1.84,12.38},{2.8,-0.67,12.38},{3.98,-1.49,12.38}};
	lootPos[] = {{2.00415,-1.33325,12.3769},{0.0378418,-1.23608,-10.8254}};
};
// ALT-MAP Support 
class Land_sara_Domek_sedy: Residential // single story stucko #39
{
	zedPos[] = {{1.72266,2.12744,-2.14196}};
	lootPos[] = {{-1.76367,-1.11328,-2.14196},{-5.0127,3.01953,-2.14196},{5.41211,2.625,-2.14196},{4.86035,-0.738281,-2.14196}};
};
class land_mbg_brickhouse_01: Residential // 2 story brick outer staircase stripped
{
	zedPos[] = {{2.13965,2.89258,-3.35652}};
	lootPos[] = {{-7.06543,4.02197,-0.051506},{5.55518,-0.523438,-0.051506},{-0.717773,4.01855,-0.051506},{-2.00293,-2.35107,-3.35652},{4.99219,-0.20752,-3.35652},{-6.80469,3.94043,-3.35652}};
};
class Land_dum_mesto_in: Residential // 2 story some boarded windows estate
{
	zedPos[] = {{4.85645,1.62305,-1.28095}};
	lootPos[] = {{ -5.53796,-2.51996,-3.99769 },{ -4.66113,1.34052,-4.26331 },{ -4.9137,3.4718,-4.26331 },{ 0.397583,-2.74866,-4.26418 },{ 2.18762,0.74707,-4.26418 },{ 4.94128,-1.67108,-4.26418 },{ 4.48279,2.82495,-4.26418 },{ 1.11023,4.69928,-2.75561 },{ 4.98938,3.79883,-1.28095 },{ 5.55957,-1.61218,-1.28095 },{ 0.695679,-2.18268,-1.28095 },{ -2.42969,-1.18854,-1.27582 },{ -4.77722,3.51996,-1.27582 }};
};
class Land_dum_mesto2: Residential // 2 stucco red/orange light by door
{
	zedPos[] = {{-3.01074,1.48145,-0.945732}};
	lootPos[] = {{2.46582,7.10742,-4.34475},{2.87305,4.03906,-4.34475},{-3.56738,4.05078,-4.34475},{-2.49902,0.46875,-4.34475},{1.77734,-7.41797,-4.34475},{-3.24512,-7.69922,-4.34475},{-3.16113,-1.58984,-4.34475},{3.19531,1.64258,-0.945168},{-3.19141,7.76563,-0.944004},{-0.253906,4.78516,-0.944004},{-3.35645,-5.74414,-0.944004},{-1.70508,-7.22656,-0.944004},{1.21973,-1.07617,-0.944004}};
};
//Land_MBG_GER_ESTATE_2 in Office.hpp
class Land_MBG_GER_HUS_4 : Residential // 2 stucco red/orage light by door
{
	zedPos[] = {{-3.01074,1.48145,-0.945732}};
	lootPos[]={{-4.05176,0.607422,-0.112886},{4.31885,2.46094,-0.112885},{4.58203,-2.88672,-0.112886},{5.85449,1.11523,-3.11289},{3.30811,-5.375,-3.11289},{-3.5708,6.20703,-3.11288}};
};
class Land_dum_rasovna: Residential // old stucco window-dor-door tile roof
{
	lootPos[] = {{-1.271,3.38281,-2.69958},{3.14893,3.86255,-2.69958},{3.30957,-4.17871,-2.69958},{-0.936523,-1.97412,0.242605},{1.05518,3.77271,0.242605}};
	lootPosSmall[] = {{-0.964844,-3.52148,0.952604},{0.613281,-0.726807,-2.69958},{3.69873,-1.69995,-2.69958}};
	zedPos[] = {{-1.08252,-1.93018,-1.79458},{-1.68555,2.19971,-1.79458}};
};
class Land_cihlovej_dum_in: Residential { // door, red-blu light, 2 windows
	zedPos[] = {{-1.69922,0.681641,-1.8147}};
	lootPos[] = {{-0.0117188,0.0441895,-1.81473},{-1.76758,2.24805,-1.8147},{-2.88965,-1.64795,-1.8147},{1.84277,-2.07983,-1.81471},{1.58691,-1.3374,-5.27588},{1.22852,2.57324,-5.27588}};
};
class land_mbg_ger_rhus_1: Residential { // brick 1 door 4 windows
	lootChance = 0.3;
	lootPos[] = {{-1.85156,3.59961,-0.0356913},{3.04688,1.85254,-0.465693},{3.36328,0.257813,-0.465693},{-2.74023,-3.26465,-0.465693},{1.23828,-4.19531,-2.38569},{1.56055,2.37012,-2.86569},{-10.4941,3.8916,-0.454963},{-9.91797,-4.14453,-0.454963},{-5.84375,0.373047,-0.174962},{-4.50977,0.0859375,-3.35496}};
	lootPosSmall[] = {{-1.4707,4.39844,-0.0356913},{1.56055,0.314453,-0.185692},{2.53516,0.682617,-3.25569},{3.62695,0.696289,-2.50569},{-3.34375,3.22852,-2.43569},{-3.32031,2.38086,-1.95569},{-4.81055,1.39453,-0.454963},{-6.64844,-4.29102,-0.454963},{-4.32617,-1.61035,-2.51496},{-6.30664,-4.11328,-2.37496}};
	zedPos[] = {{-2.03125,6.38867,-2.93606},{-8.33398,-5.82813,-2.73209}};
};
class Land_MBG_GER_RHUS_2 : Residential // cement 1 door 4 windows
{
	zedPos[] = {{-2.77441,-3.31738,-3.36569}};
	lootPos[]={{2.33398,-1.23145,-3.36569},{2.08203,-1.7998,-0.465693},{-0.678711,-4.04883,-0.465693},{2.33008,3.3291,-0.465692}};
};
class Land_MBG_GER_PUB_2 : Residential // fionas irish pub
{
	zedPos[] = {{4.20264,-3.15381,-3.53086},{-6.24268,-4.08228,-3.53085}};
	lootPos[]={{-0.338867,-5.44336,-3.53086},{-2.61182,-4.51978,-3.53086},{-6.23779,-2.42676,-3.53085},{4.42334,-4.17285,-0.630859},{3.15088,4.45898,-0.630852}};
};
class Land_sara_domek_vilka : Residential // reddish villa - no entry
{
	lootPos[]={{-5.53467,-1.77637,-4.17358},{3.11279,6.25879,-4.1599},{0.339844,7.14258,-4.1599}};
};
class Land_mbg_apartments_big_01 : Residential // brick with archways, limited access
{
	lootPos[]={{-4.7915,4.07861,4.80171},{-6.07764,-4.86182,4.80168},{9.38916,-7.12158,-1.05012},{-11.3857,-5.63916,-1.05012},{-11.2231,8.8335,-1.05013},{11.4961,7.89697,-1.05012},{4.59082,-5.81592,-4.34196}};
};
class Land_dum_ras: Residential { // stucco 1 window, 2 doors
	zedPos[] = {{0.891602,2.02539,-2.66959},{0.189453,-3.6333,-2.66958},{0.952148,2.08594,0.272604}};
	lootPos[] = {{-1.53223,3.34424,-2.66958},{1.36621,-0.507813,-2.66958},{0.860352,3.72705,0.272604},{-0.767578,-1.96289,0.272604},{-0.27832,-3.96045,0.272604}};
};
class Land_deutshe_mini : Residential // stucco 3 windows, doorway
{
	zedPos[] = {{2.51074,-2.4657,-2.74846},{2.51953,1.31262,-2.74846}};
	lootPos[] = {{-4.34277,-2.54297,-2.74846},{-0.624023,-0.357422,-2.74846},{0.853516,1.04395,-2.74846},{-2.75781,2.44336,-2.74846}};
};
class land_seb_bouda1: Residential { // cement floor1, wooden floor2
	zedPos[] = {{-2.27832,0.0546875,0.573326},{-0.192871,-2.34766,1.13067}};
	lootPos[] = {{2.49316,-2.44238,1.13067},{-0.645996,-2.44824,1.13067},{-0.924316,-0.460938,0.573963},{-2.89697,1.9043,0.571716},{2.80566,1.2334,-3.28989},{-2.38672,-0.893555,-3.28989},{-2.7666,2.41699,-3.28989}};
};
class land_x_vez_tex: Residential { // brick tower
	zedPos[] = {{-0.80957,1.62183,-4.59428}};
	lootPos[] = {{0.433105,-1.02734,-0.273926},{1.00391,3.02197,-0.272713},{1.36426,0.449219,-0.273571},{-1.89795,3.22168,-0.27232},{-5.00537,-3.64307,-0.274128}};
};
class Land_House_K_3_EP1: Residential // beige stucco
{
	lootPos[] = {{ 0.524414,3.5166,-0.53767 },{ 1.53491,-0.0644531,-0.790318 },{ -0.887451,0.615234,-0.790318 },{ -4.46191,1.38379,-0.795597 },{ 1.1001,5.40723,2.81719 }};
};
class Land_House_C_5_V2_EP1: Residential // beige stucco
{
	lootPos[] = {{ 3.42529,1.77832,-1.36692 },{ -3.6687,1.98779,-1.36692 },{ -2.0271,-2.9126,-1.36692 },{ -1.271,-3.94385,1.33329 }};
};
class Land_House_C_5_V3_EP1: Residential // beige stucco
{
	lootPos[] = {
		{2.43799,1.03662,2.2605},{-1.00391,-3.9248,1.22732},{0.83374,4.91699,-0.671498},{-1.63037,3.66699,-1.4815},{-1.24463,-3.43701,-1.4815}
	};
	lootPosSmall[] = {
		{3.44287,1.23535,1.4205},{3.64917,3.85156,1.4605},{-0.623779,-5.09424,1.24732},{2.31201,0.770996,-0.0414982},{2.53198,0.82959,-0.731498},{1.81738,5.23926,-1.4815},{-4.40332,0.501465,-1.0415},{-0.46582,-2.83594,-1.0815},{-0.466797,-3.58984,-0.401499}
	};
	zedPos[] = {{-3.54736,1.73535,-0.596497},{2.47021,4.54834,-0.59645},{1.73682,2.96338,2.2955},{-3.40234,-4.05664,2.18232}};
};
class Land_House_L_1_EP1: Residential // beige stucco
{
	lootPos[] = {{1.63135,-1.2251,-0.619034},{-0.165039,-1.74463,-0.6114815},{-1.18311,-0.15918,-0.596542}};
};
class Land_House_C_5_V1_EP1: Residential // beige stucco
{
	lootPos[] = {{1.01025,4.85181,-1.4815},{3.42773,1.4248,-1.4915},{-1.62939,-4.69336,-1.4815},{-1.56982,3.66333,-1.4915},{2.28418,1.03076,2.2605},{-0.941895,-3.75952,1.16351}};
	lootPosSmall[] = {{0.615479,4.92847,-0.671498},{2.23071,0.780518,-0.411497},{2.61011,0.823975,-1.0915},{-4.35205,-0.0966797,-1.0515},{-0.5271,-2.93677,-1.4215},{-4.2854,3.09082,-1.4715},{-4.42822,-5.13232,-1.4815},{-0.468018,-3.18481,-0.0414963},{2.96582,1.17114,2.2605},{1.85205,4.83716,1.7605}};
	zedPos[] = {{-3.11206,1.50952,-0.596497},{2.39453,4.8396,-0.592795},{1.48633,3.10425,2.2955}};
};
class Land_House_C_2_EP1: Residential // beige stucco 2 rollup doors on right., blue door on left
{
	lootPos[] = {{-3.63477,2.83398,-2.27891},{5.94116,1.08691,-2.30269},{0.387207,1.1936,-1.47782},{5.49438,-1.47388,1.56868},{-2.24487,-1.44019,0.547503},{-2.01343,3.41553,0.547503},{5.06909,1.21997,0.746294},{5.75464,-4.69043,0.794252}};
	lootPosSmall[] = {{0.1604,1.06812,-2.00456},{-0.469482,1.10962,-2.2006},{1.1167,0.707031,-1.78269},{-1.62158,-1.72437,1.1175},{-1.63965,-1.27368,1.4575},{5.88379,-3.06787,1.17425},{-2.31738,3.16724,1.3775},{-1.8562,3.80322,1.3775},{-0.393799,3.50586,-1.61131},{6.06934,0.0444336,-2.07269},{-1.95215,-1.91943,-2.33913},{2.17334,-1.75024,0.74663}};
	zedPos[] = {{-0.131592,3.38794,1.63951},{-4.25537,1.24023,1.4225},{2.3269,1.89136,-1.43735},{-1.87183,-0.48584,-1.4121},{1.21802,-1.58765,1.67137}};
};
class Land_House_K_7_EP1: Residential // beige stucco
{
	lootPos[] = {{ -0.995361,1.89014,-0.218372 },{ -4.9541,3.85254,-0.218374 },{ -3.4502,4.0376,3.32767 }};
};
class Land_House_C_4_EP1: Residential // beige stucco
{
	lootPos[] = {{ 5.38452,-0.364746,-3.48355 },{ 3.16089,2.81616,-3.48355 },{ -3.36499,2.44629,-3.48355 },{ -4.60474,0.0483398,-3.48355 },
		{ 4.34985,-0.835205,-0.35146 },{ 1.84668,-3.7168,-0.352423 },{ -1.23096,-5.15308,-0.27861 },{ -4.16602,2.48022,-0.348963 }};
};
class Land_House_C_11_EP1: Residential // 2 story wood railings
{
	lootPos[] = {{ -4.875,-3.75586,-2.45703 },{ -1.22852,-3.17529,-2.08453 },{ 6.55859,0.731934,-2.08453 },{ 4.74072,3.21436,-2.08453 },{ 4.39551,0.458984,-2.08453 },{ 0.449219,-3.03857,0.972969 },{ 4.8291,3.44629,0.972969 }};
};
class Land_House_C_1_EP1: Residential // 
{
	lootPos[] = {{-3.62476,-1.83301,-0.967744},{3.19263,-2.92676,-0.937744},{7.94824,-1.15381,-0.957744}};
	lootPosSmall[] = {{-7.64917,-2.33325,-0.257745},{-2.65161,-2.34473,-0.717744},{2.07666,-3.62549,-0.0177441},{7.56982,-2.3689,-0.257744},{2.6355,-1.62378,-0.947745}};
	zedPos[] = {{-5.45166,-0.360596,-0.0527439},{5.60938,-1.80347,-0.0527439}};
};
class Land_dum_istan3_hromada2: Residential // brick 2 story
{
	lootPos[] = {{ 1.67627,3,-4.62603 },{ -1.47363,4.92285,-1.28517 },{ 6.43848,1.93555,2.08801 }};
	lootPosSmall[] = {{7.02344,5.71191,2.08801},{0.856445,-1.72266,-1.28517},{-2.51758,1.2002,-1.28517},{5.18945,2.93848,-4.62604}};
	zedPos[] = {{-1.77148,2.59961,-0.410172},{4.46387,1.85254,-3.75103}};
};
class Land_House_C_3_EP1: Residential // 
{
	lootPos[] = {{ 6.61987,-1.8667,-3.91483 },{ 5.80493,1.21094,-3.91483 },{ -7.11523,2.78418,-3.86868 },{ -6.45874,-0.478271,-3.86868 },{ -6.37598,-2.27344,-3.86868 },{ -4.84521,-2.55664,0.576136 },{ -1.21606,-1.24634,1.96108 }};
};
class Land_House_C_1_v2_EP1 : Residential // 
{
	lootPos[] = {{6.24365,-0.537109,-1.30966},{4.14746,1.3584,-1.31308}};
};
class Land_House_C_9_EP1: Residential // 
{
	lootPos[] = {{ -3.47339,2.13086,-3.74726 },{ -3.17773,4.19849,-3.74837 },{ -0.839844,5.7041,-3.74944 },{ 4.67529,1.19897,-3.74832 },{ 4.20508,-1.85229,-3.74805 },{ 1.01074,-0.609619,-0.152166 },{ 0.213379,1.56616,-0.152166 },{ 1.66138,4.33472,-0.152166 },{ 4.38208,-5.14136,-0.152166 }};
};
class Land_House_K_1_EP1: Residential // 
{
	lootPos[] = {{ -0.685547,4.02161,1.56626 },{ 3.71387,5.48114,1.56626 },{ 3.23438,2.35388,1.56626 },{ -3.30566,4.65558,1.54929 },{ -3.77539,2.02087,1.60863 }};
};
class Land_House_K_8_EP1: Residential // 
{
	lootPos[] = {{2.94263,2.71948,3.34996},{-0.0541992,3.51294,3.34996},{-2.81274,1.99365,0.231133},{-2.59253,3.66528,-1.81557},{-2.55493,-2.54126,-2.63675},{2.97803,-1.89355,-2.64059}};
	lootPosSmall[] = {{-0.681641,0.580322,3.54996},{1.30103,3.72339,3.81996},{1.45947,2.58374,3.34996},{-3.10376,-1.51025,3.34996},{-4.21533,1.6499,0.0964928},{3.22192,3.68018,0.234936},{-3.19409,-1.90552,0.496338},{3.31445,-0.210938,-1.82104},{3.00293,-0.161865,-2.16398},{0.443359,-3.27417,-2.67695},{-3.1377,1.33936,-2.2182}};
	zedPos[] = {{-2.60083,-1.24683,-1.66764},{3.30005,-1.26563,1.12351},{-0.615479,2.00049,1.1274},{-1.73755,2.1958,-1.708}};
};
class Land_House_C_5_EP1: Residential // 
{
	lootPos[] = {{ 3.1499,2.39502,-1.36692 },{ -1.80127,-2.98022,-1.36692 }};
};
class Land_dum_istan3_pumpa: Residential // brick
{
	lootPos[] = {{-2.14502,3.03662,-1.86787},{4.09619,-0.563965,1.47485},{0.189453,0.540039,1.47485},{-1.73682,2.44775,1.47485}};
};
class land_sara_domek_kovarna: Residential
{
	zedPos[] = {{0.0998535,-0.891602,-0.880356}};
};
class land_sara_domek_hospoda: Residential
{
	lootPos[] = {{-2.14844,-3.56396,-2.74878}};
	lootPosSmall[] = {{-1.16064,-4.72485,-2.75951}};
	zedPos[] = {{1.48291,-3.28223,-1.85291}};
};
class LAND_vokzal_big: Residential // Train Station
{
	lootPos[] = {{7.28613,-0.216797,-7.96283},{6.84961,2.56152,-7.96283},{6.9834,-4.98047,-7.96283},{-7.07227,1.28223,-7.96283}};
};
class LAND_Zachytka : Residential
{
	lootPos[] = {
		{3.79492,-4.12891,-2.02697},
		{-4.92285,-6.8584,-2.02697},
		{-3.6543,-6.7002,-2.02697},
		{-2.60449,-6.87891,-2.02697},
		{-1.82422,0.0361328,-2.02697},
		{-6.2832,-4.51074,-2.02697},
		{-3.60547,5.1875,-2.02697},
		{4.42188,11.2158,-2.02697}};
};
class LAND_hospoda  : Residential
{
	lootPos[] = {
		{3.46094,-1.42871,-1.80302},
		{2.40137,-1.22656,-1.80307},
		{7.81836,-1.63281,-1.80282},
		{2.04004,-6.71777,-1.80289},
		{-5.56641,0.793945,-1.80295},
		{-4.18164,8.64063,-1.80286},
		{1.16602,5.0791,-1.80348},
		{1.21582,3.73242,-1.8034},
		{0.248047,5.55176,-1.80324},
		{-1.84766,3.92969,-1.80313},
		{-1.85254,0.222656,-1.80321}};
};
class LAND_Kiosk2 : Residential
{
	lootPos[] = {{-20.7441,45.2878,3.05876},{-3.80933,-33.6328,3.02246},{-3.57007,-22.666,3.02246},{4.76587,-24.3711,-0.618923},
		{-1.10449,43.1938,-0.58263},{8.77441,23.7346,-0.845428},{-9.86914,41.6533,3.05876},{7.84668,20.991,4.76736},{6.91211,27.9067,10.1178}};
};
class LAND_skola : Residential
{
	lootPos[] = {
		{15.8508,20.459,-2.00361},
		{29.0132,22.3887,-2.00361},
		{30.6335,16.1104,-2.00361},
		{30.7412,5.33691,-2.00361},
		{18.7554,5.07324,-2.00361},
		{2.84912,14.2744,-2.00361},
		{-1.27197,12.2324,-2.00361},
		{-5.66699,16.6445,-2.00361},
		{-2.93408,22.0967,-2.00361},
		{5.48535,21.7969,-2.00361},
		{-9.52954,-8.64063,-2.00361},
		{-18.5305,-9.60449,-2.00361},
		{-23.9783,-0.905273,-2.00361},
		{-8.50586,13.9482,-2.00361},
		{5.84448,0.175781,-2.00361},
		{2.56885,-14.167,-2.00361},
		{-3.15063,-14.084,-2.00361},
		{-3.76294,-21.2754,-2.00361},
		{5.4397,-24.5635,-2.00361},
		{18.5049,-11.9141,-2.00361},
		{10.7795,-18.4443,-2.00361},
		{18.3979,-21.9854,1.22083},
		{20.1707,-14.1572,1.22083},
		{30.334,5.12402,1.22083},
		{22.9521,12.1387,1.22083},
		{1.45825,18.208,1.22083},
		{-5.56128,20.1572,1.22083},
		{-6.19165,15.4678,1.22083},
		{-1.05029,9.69141,1.22083},
		{6.17896,5.19434,1.22083},
		{5.00513,2.78711,1.22083},
		{5.81836,-5.65625,1.22083},
		{-0.54541,-15.1104,1.22083},
		{1.8418,-19.8584,1.22083},
		{-2.10864,-21.9961,1.22083},
		{-5.78857,-24.9277,1.22083},
		{16.3679,-15.4463,1.22083},
		{28.0537,-17.1328,1.22083},
		{22.1833,11.416,-2.00361}};
};
class LAND_Tav_Panelak2 : Residential
{
	lootPos[] = {{2.7627,-5.62524,5.43665},
		{2.63867,-0.156494,5.43665},
		{3.4873,2.76855,5.43665},
		{6.06152,3.64966,5.43665},
		{6.70996,0.734619,5.43665},
		{4.71875,-1.69263,5.43665},
		{-0.347656,-2.23315,5.43665},
		{0.814453,-1.73901,2.71097},
		{-0.545898,-2.29468,2.71097},
		{-0.415039,4.25122,1.32864},
		{0.75,-2.01318,0.0714264},
		{0.644531,-1.86401,-2.62859}};
};
class LAND_Tav_panelak : Residential
{
	lootPos[] = {{5.24121,-6.39453,2.77144},
		{6.71191,-5.43262,2.77144},
		{4.65625,-1.83838,2.77144},
		{6.69531,0.225586,2.77144},
		{6.54395,3.06519,2.77144},
		{3.40234,3.32324,2.77144},
		{2.61523,0.798096,2.77144},
		{2.7041,-4.98389,2.77144},
		{3.66016,-6.17651,2.77144},
		{-0.982422,-1.86328,2.77144},
		{-0.904297,4.13086,1.32864},
		{0.942383,-2.10474,0.0714226},
		{-2.56836,-1.68628,0.0714226},
		{-2.69531,3.42407,0.0714226},
		{-6.24902,3.01392,0.0714226},
		{-6.07227,0.556396,0.0714226},
		{-5.75488,-2.03857,0.0714226},
		{-6.66406,-4.34497,0.0714226},
		{-5.49219,-6.70581,0.0714226},
		{-2.41602,-4.19434,0.0714226},
		{-3.70801,-6.17212,0.0714226}};
};
class LAND_Tav_Panelak3 : Residential
{
	lootPos[] = {{0.0878906,0.793457,-10.8154},{-0.810547,3.44824,-10.8154}};
};
class LAND_Big_Panelak : Residential
{
	lootPos[] = {{3.30566,-9.23413,-14.7521},{3.10059,-7.05005,-14.7521},{5.36914,0.495361,-14.7521},{-0.236328,-3.16772,-14.7521},{3.05078,-0.838379,-14.7521}};
};
class LAND_Posta : Residential
{
	lootPos[] = {{-17.4678,-9.28809,1.00044},{-16.5732,-1.32227,1.00044},{-3.60254,-5.11377,1.00044},{9.72168,-6.61035,1.00044},{17.333,-8.2085,1.00044},
		{13.3633,7.1958,1.00044},{1.56445,8.49707,1.00044}};
};
class Land_smd_dum_istan2b : Residential // stucco 4 windows up, 2 down on left
{
	zedPos[] = {{-2.41797,2.20996,-2.34969}};
	lootPos[] = {{5.30371,-3.37402,0.822983},{-2.41504,-4.07617,0.823578},{-3.25977,-2.8623,3.80017},{-3.63574,1.1543,3.8002}};
};
class land_smd_dum_olez_istan1_open: Residential { // worn stucco 3 windows up, stairs-door on left, 1 window down
	lootPos[] = {{-5.4375,-4.38379,1.35497},{5.75781,-3.31934,1.35497},{1.53516,-2.0625,1.35497},{-2.14941,-4.56445,-1.85398},{-6.79688,2.14453,-1.84398},{3.61523,-0.371094,-1.824}};
	lootPosSmall[] = {{-6.11914,-4.14453,2.16497},{2.4707,3.67773,1.96497},{6.42773,-0.5,1.34497},{7.48047,2.37109,-1.434},{-1.98047,-4.16504,-1.07398},{-7.60254,-4.06348,-0.883982},{-7.74902,2.51074,-1.16398},{5.85352,2.37695,-1.854}};
	zedPos[] = {{1.33691,-5.02441,-1.5178},{-4.22168,4.75391,-1.66303}};
};
class Land_smd_dum_olez_istan2_maly_open : Residential // worn stucco 3 windows up, stairs-door on left, 1 window down
{
	zedPos[] = {{-2.6709,-1.38867,-1.87241}};
	lootPos[] = {{-2.33594,2.87939,-1.87241},{-0.493164,-1.98486,1.34656}};
};
class land_smd_dum_olez_istan2_open: Residential { // cement open door shutter window wood canopy
	lootPos[] = {{0.0185547,4.61133,0.0584984},{0.412598,-4.66211,0.338498},{-5.71582,5.63477,-0.431501},{-4.5127,-4.87695,-0.431501}};
	lootPosSmall[] = {{-1.46338,6.05078,0.718499},{-4.68652,-3.71973,0.528499},{-0.162109,-4.69238,0.0184984},{-6.41113,5.08398,0.798498}};
	zedPos[] = {{4.92383,-3.12109,0.0317497}};
};
class Land_smd_house_y_open : Residential // cement open door, AC, blue roof
{
	zedPos[] = {{-0.40625,3.14844,-1.40688}};
	lootPos[] = {{2.68066,-3.13281,-1.40688},{2.41504,3.57764,-1.40688},{-3.43652,2.75293,-1.40688}};
};
class Land_majak : Residential // stone lighthouse
{
	zedPos[] = {{-0.756836,1.10938,-8.07302}};
	lootPos[] = {{-0.756836,1.10938,-8.07302},{-0.483398,-0.784668,-8.07302},{0.208984,-1.5918,1.72248}};
};
class Land_smd_sara_zluty_statek_in : Residential // 
{
	zedPos[] = {{4.76367,-2.59277,-2.91795}};
	lootPos[] = {{3.50293,-2.22168,-2.91434},{8.08105,2.90723,-2.8938},{3.50586,3.97852,-2.88629},{-1.37305,1.58594,-2.88646}};
};
class Land_smd_dum_olezlina_open : Residential // 4 windows up 3 down and door
{
	zedPos[] = {{3.68604,1.09766,-3.83481}};
	lootPos[] = {{3.68604,1.09766,-3.83481},{-2.39355,-2.43457,-3.83481},{-4.78809,-2.15039,-0.434065}};
};
class Land_majak2 : Residential // stone lighthouse
{
	zedPos[] = {{0.125977,1.02539,-8.07302}};
	lootPos[] = {{-0.570801,1.09668,-8.07302},{1.74023,1.0752,1.72248}};
};
class Land_smd_budova3_open : Residential // blue doors + fireplace
{
	zedPos[] = {{1.44531,-0.165039,-1.91334}};
	lootPos[] = {{-0.738281,-1.79004,-1.9121},{-1.49609,2.75537,-1.9142}};
};
//Land_budova5 in Military.hpp
class land_smd_dum_istan3_hromada: Residential { //brick 2 story with awning
	lootPos[] = {{0.293945,-1.60156,-3.328},{-1.91406,-1.65332,-3.328}};
	lootPosSmall[] = {{0.551758,-4.12695,-3.328},{0.626953,-0.547852,-3.328}};
	zedPos[] = {{-0.154297,5.01172,-2.46689},{-9.95117,1.99902,-2.46689},{10.2998,1.82227,-2.68886}};
};
class Land_smd_kasarna : Residential // 
{
	zedPos[] = {{6.47363,20.6445,-8.77723},{-14.2305,16.1533,-8.77723}};
};
// ALT-MAP Support 

//DZE ADDED BELOW
class land_r_housev2_04: Residential {
	lootPos[] = {
		{0.364502,3.06128,-4.08876},{-4.49097,3.29565,-4.0887},{7.0625,-1.54053,-4.09079}
	};
	lootPosSmall[] = {
		{-5.88696,2.77051,-4.08894},{-4.32666,6.00415,-4.0887},{7.37158,4.41968,-4.08918},{6.17065,2.39063,-4.09028}
	};
	zedPos[] = {{-1.72021,2.7146,-3.20429},{2.7522,2.9668,-3.20421},{4.73706,-0.942627,-3.20546}};
};
class land_rozvodna: Residential {
	lootPos[] = {{-6.8208,-1.58789,-0.369419}};
};
class land_jzd_bezstrechy: Residential { // multi-story concrete bars on windows
	zedPos[] = {{6.62451,1.67969,-5.22504},{5.60889,6.54102,-5.10962}};
	//lootPos[] = {{6.62451,1.67969,-5.22504},{1.70166,3.48828,-5.22504},{5.60889,6.54102,-5.10962},{-5.21094,7.38477,-5.10962}};
	lootPos[] = {{-10.4614,-2.97461,-5.22504},{0.170898,0.177734,-5.22504},{-0.368652,-3.34668,-5.22504},{0.905762,2.52344,-5.22504},{0.802246,2.12305,-0.40476},{1.05615,1.88574,-3.01179},{8.00244,0.787109,-5.22504}};
};
class land_domek_podhradi_1: Residential { // brown wooden barn one story
	zedPos[] = {{-2.18018,-3.02637,-2.75047},{-0.874756,3.29346,-2.7391}};
	//lootPos[] = {{5.11816,0.963867,-2.73913},{1.84717,-0.317383,-2.73914},{-5.66992,0.883789,-2.75047},{0.924805,-2.87988,-2.75047},{2.50977,-0.691406,-2.73915},{-0.874756,3.29346,-2.7391}, {-2.71924,0.0463867,-2.73914}};
	lootPos[] = {{5.20862,3.45215,-2.7391},{3.04761,1.61621,-2.73912},{2.7594,-1.33691,-2.73915},{-3.32617,4.14404,-2.73909}};
};
class Land_bouda2_vnitrek: Residential {
	lootPos[] = {{2.33496,0.372559,-0.610508},{-0.845703,2.32129,-0.610506},{-3.27344,-2.27295,-0.610508}};
};
class land_senik: Residential {
	lootPos[] = {{-4.56445,-2.97705,-4.13721},{13.1641,-6.80127,-4.28022},{-4.23242,-0.213379,-4.1315},{-3.44043,4.7998,-4.12115},{-7.64453,3.81445,-4.12319},{-14.0889,-5.66602,-4.14276},{-1.25977,-3.44336,-4.13817}};
};
class land_zd_1: Residential {
	lootPos[] = {{2.14258,3.37402,-3.67255},{-1.60645,-3.25098,-3.67255},{0.649902,-2.38086,-3.67255},{-1.16113,1.41406,-3.67255},{2.88721,-2.80078,-3.67255},{-4.45117,-3.0127,-4.04225},{-5.94385,3.13867,-4.04225}};
};

class land_plynom: Residential {
	lootPos[] = {{1.07568,-0.65625,2.21929},{-0.184082,-1.46973,2.21929},{-1.24854,-0.0126953,2.21929},{1.1377,-0.887695,-2.60304},{-1.3877,0.386719,-2.60304},{-0.822754,-1.33398,-2.60304}};
};
class land_marsh1: Residential {
	lootPos[] = {{3.76953,-5.73193,-3.95897},{-0.986816,-4.26074,-3.95897},{2.52637,0.376465,-3.95897},{4.78955,2.92969,-3.95897},{4.56543,6.82227,-3.95897},{-2.88184,4.24121,-4.01684}};
};
class land_cihlovej_dum_mini: Residential {
	lootPos[] = {{-2.4646,-0.78418,-2.86942},{-1.75586,2.88525,-2.86942},{2.76587,2.08154,-2.86942},{1.96265,-1.98877,-2.86942},{0.0109863,0.876465,-2.86942},{0.116455,3.05762,-2.86942}};
};
class Land_hruzdum: Residential {
	lootPos[] = {
		{-1.67188,3.71826,-4.72847},{-2.52295,-1.02246,-1.16867},{-1.94971,1.22021,1.5983}
	};
	lootPosSmall[] = {
		{-2.84448,0.796875,2.35386},{2.79614,3.2666,-1.15755},{-3.03979,2.35303,-4.72847}
	};
	zedPos[] = {{-1.66382,-1.14795,-3.82291},{-2.79248,3.60742,-0.251995}};
};
class land_smd_cihlovej_dum_mini: Residential {
	lootPos[] = {
		{0.623047,2.39746,-2.58942},{0.0996094,0.995117,-2.86942},{-4.05957,-1.01953,-2.86942},{-8.86328,2.89453,-2.86942}
	};
	lootPosSmall[] = {
		{2.89453,-1.72852,-1.91942},{2.92773,-2.3418,-2.86942},{-6.09668,3.10938,-2.86942},{-2.19629,2.9375,-2.86942}
	};
	zedPos[] = {{1.81738,0.794922,-1.99442},{-1.7959,1.10742,-1.99442},{-6.54102,1.04688,-1.99442}};
};
class land_smd_dum_istan4: Residential {
	lootPos[] = {{2.60742,-2.42188,-4.35237}};
	zedPos[] = {{0.323242,5.66113,-6.38088}};
};
class land_smd_dum_olez_istan2_open2: Residential {
	lootPos[] = {
		{-0.162109,4.91846,-0.431501},{3.25391,2.52246,-0.421501},{-3.51953,-3.80176,0.128499},{-1.56934,0.389648,-0.411501}
	};
	lootPosSmall[] = {
		{-6.44629,0.00488281,0.198499},{-4.30762,5.7207,0.568499},{0.628906,4.8291,0.338499},{-3.94824,-3.03906,0.128499},{1.19629,-5.44629,-0.0115013}
	};
	zedPos[] = {{5.4502,-3.21729,0.207455}};
};
class land_panelova3: Residential {
	lootPos[] = {{-0.0615234,2.92871,0.0510063},{6.44482,-0.967773,0.0510063},{6.26807,-3.85547,0.0510063},{-0.0327148,-5.30273,0.0510063}};
};
class land_vysoky2: Residential { // multi-story cement apt buildings. no room access
	zedPos[] = {{-0.219727,2.5332,13.2833}};
	//lootPos[] = {{-0.219727,2.5332,13.2833},{-1.83179,7.09766,13.2833},{-7.15039,-8.02441,13.2833},{4.60986,-8.9209,13.2833},{12.3555,5.91992,13.2833}};
	lootPos[] = {{6.74121,-2.95508,-15.7673},{6.63232,4.17676,-15.7673},{0.72998,-2.63574,-15.7051},{1.1958,0.116211,-15.6513},{2.84131,2.35742,13.1248},{-0.51123,2.16699,13.1248},{4.37012,0.773438,13.1248},{9.61328,13.2432,13.1248},{6.39307,-12.292,13.1248}};
};
class land_vysoky1: Residential {
	lootPos[] = {{-6.74414,5.46875,13.2833},{0.54541,4.38379,13.2833},{10.9004,1.47949,13.2833},{6.0415,-13.4297,13.2833},{1.12744,-2.39258,13.2833}};
};
class land_hotel_p2: Residential {
	lootPos[] = {{-3.26953,3.02783,-7.29951},{4.04395,-1.92188,-7.29951},{9.48145,0.459473,-7.32974},{1.53711,0.0078125,6.06893},{4.5332,0.862305,6.06893},{4.73438,-3.63232,6.06893}};
};
class land_hotel_p1: Residential {
	lootPos[] = {{-12.1006,-3.29248,-4.92428},{-3.09375,-1.66357,-4.92429},{-1.78125,3.53271,-4.92429},{-5.97852,3.80273,-4.92428},{13.8809,1.77246,-1.39091},{13.751,-9.81104,-1.39091},{12.1787,0.0078125,-3.22923}};
};
class land_dlouhy1: Residential { // multi-story cement apt buildings. some room access
	zedPos[] = {{-3.36914,7.95166,-4.95796},{-3.00684,-1.46973,-9.47917}};
	//lootPos[] = {{-3.36914,7.95166,-4.95796},{-4.4248,-1.81055,-4.96283},{25.0264,-1.64648,-4.96281},{25.6738,8.21387,-4.95789},{15.626,11.2983,-4.95636},{6.11328,6.86816,-9.48532}, {-13.5742,-1.67822,-9.47203}, {-3.00684,-1.46973,-9.47917}};
	lootPos[] = {{-6.40918,-0.21875,-9.60495},{-12.395,2.47559,-9.60091},{1.38428,3.15332,-9.61021},{1.91748,8.89746,-9.61057},{-6.90918,8.53027,-9.60461},{-12.3315,8.00195,-9.60096},{-17.9946,9.73926,-9.59713},{-9.91797,5.16699,-9.60259},{6.95801,9.37988,-9.61397},{4.39404,7.64941,-9.61224},{5.43994,9.80469,-5.09157},{0.418457,-0.611328,-5.09031},{-5.27051,7.41895,-5.08631},{2.20361,8.79004,-5.09157},{-8.93848,6.08301,-5.08698},{-9.49854,11.3086,-5.08437},{9.38232,1.54199,-5.09157},{8.95361,9.74707,-5.09157},{11.436,11.4756,-5.08435}};
};
class land_dlouhy2: Residential {
	lootPos[] = {{1.73047,5.30957,-9.32314},{-1.38867,-0.568848,-9.31474},{-1.47461,-5.5957,-9.3145}};
};

class Land_dulni_bs: Residential {
	lootPos[] = {{2.76758,2.70068,-1.75205},{2.34668,-1.28564,-1.75205},{-0.478516,-2.64844,-1.75205},{-0.53418,3.11133,-1.75205}};
};
class land_seb_mine_maringotka: Residential {
	lootPos[] = {{0.423828,0.721191,-0.612675},{-0.976563,-1.32764,-0.612675}};
};
class Land_hut_old01: Residential {
	lootPos[] = {{2.2793,-7.06348,-3.06107},{-3.3584,-1.7334,-3.01178},{-5.0332,-0.929688,-3.0112}};
};

class Land_ruin_01_PMC : Residential
{
	lootPos[] = {{-2.57568,2.16443,-1.76358},
		{-2.64172,-2.50488,-1.76358},
		{0.851563,1.67505,-1.76358}};
};
class Land_Ruin_Cowshed_a_PMC : Residential
{
	lootPos[] = {{-3.573,2.80774,-2.31227},
		{8.85077,-2.67871,-2.46388},
		{-2.83069,-5.90613,-2.46388},
		{8.89893,-5.66711,-2.46388}};
};
class Land_Ruin_Cowshed_b_PMC : Residential
{
	lootPos[] = {{10.4032,2.35046,-3.14048},
		{2.99207,-3.36682,-3.13994}};
};
class Land_Ruin_Cowshed_c_PMC : Residential
{
	lootPos[] = {{5.05737,2.52881,-3.09486}};
};
class Land_majak_podesta: Residential
{
	lootPos[] = {
		{-1.22461,-2.17969,2.28329},
		{1.14844,-2.9707,2.28329}};
};
class land_nasypka: Residential
{
	lootPos[] = {
		{-1.46045,-0.168945,6.56824}
	};
	lootPosSmall[] = {
		{-1.58691,0.717285,6.56824}
	};
	zedPos[] = {{1.50659,-0.027832,-5.55527}};
};
class land_dum_istan3: Residential
{
	lootPos[] = {
		{-8.4917,-0.922363,0.585144},
		{5.97852,1.38037,0.585148},
		{3.55176,-5.42822,0.58514},
		{-2.33105,3.74805,-2.67237}};
};
class land_house_y: Residential
{
	lootPos[] = {
		{-0.570313,-5.21387,-1.40696},
		{-5.15625,-5.32275,-1.40696},
		{2.34766,4.9917,-1.40696}};
};
class land_dum_istan4_inverse: Residential
{
	lootPos[] = {
		{-2.77246,-1.72949,-4.33588},
		{5.30176,5.76563,-7.28588},
		{-0.282227,5.89746,-7.28588},
		{-6.5918,5.96973,-7.28588}};
};
class Land_duala_mini: Residential
{
	lootPos[] = {
		{-1.37207,2.25488,-2.74846},
		{-3.43457,-2.04932,-2.74846},
		{3.82959,0.034668,-2.74846},
		{3.79102,-2.25977,-2.74846}};
};

class land_dum_istan2b: Residential
{
	lootPos[] = {
		{-6.44531,-5.13037,3.80019},
		{-6.71777,2.81592,3.80019},
		{ 3.33887,-0.539307,0.822979},
		{-0.506836,-2.2229,0.822979},
		{-3.93457,2.11401,-2.29981}};
};
class land_hut01: Residential
{
	lootPos[] = {
		{ 0.304749,-0.543213,-0.448339 },
		{ 0.885254,2.90747,-0.44834 }};
};

class land_housev2_05: Residential
{
	zedPos[] = {{-3.78809,-0.407715,-2.06879},{5.36499,7.90381,-2.08879}};
};
class land_hut02: Residential
{
	lootPos[] = {
		{ -0.498901,2.974,-0.445764 },
		{ -1.07245,-0.756958,-0.445764 }};
};
class land_hut04: Residential
{
	lootPos[] = {
		{ -1.07227,-0.354492,-0.437198 },
		{ 0.939697,2.78271,-0.437198 }};
};
class land_mbg_killhouse_4: Residential { // cement 2 story 
	//lootPos[] = {{2.97949,2.16211,-3.84318},{6.88184,-3.24219,-3.84317},{-3.87012,5.46484,-3.84317},{0.474609,-5.08398,-0.543175},{6.9248,2.49219,-0.543175},{-2.39063,-0.128906,-0.543179}};
	lootPos[] = {
		{7.22266,-4.10205,-3.84318},{-2.04883,0.195313,-3.84318},{-6.33398,2.08691,-3.84318},{3.6582,0.32666,-3.84318},{7.24805,6.55469,-3.84318},{6.74023,2.40967,-0.543176},{-1.83203,2.08301,-0.543176},{6.85742,0.0131836,-0.543176},{-1.89258,-0.352051,-0.543176}
	};
	lootPosSmall[] = {
		{2.41992,-4.59082,-3.84318},{-1.61133,-4.5249,-3.84318},{2.61719,3.53076,-3.84318},{7.63867,6.79102,-0.543176},{2.54883,6.95605,-0.543176},{-1.70898,6.92188,-0.543176},{2.70313,-1.13672,-0.543176},{-6.58008,-4.49268,-0.543176}
	};
	//zedPos[] = {{2.97949,2.16211,-3.84318},{-3.87012,5.46484,-3.84317},{6.9248,2.49219,-0.543175}};
	zedPos[] = {{0.597656,-6.93311,-3.62662},{-8.15625,1.8877,-3.62662}};
};
class Land_House_K_6_EP1: Residential
{
	lootPos[] = {
		{2.36108,1.41309,-1.60797},
		{-2.57178,1.42285,-1.59425},
		{-4.81445,2.98193,1.48639},
		{-0.123047,3.83203,1.47144},
		{2.7063,0.193359,4.42145},
		{-4.3584,-2.99609,4.33153},
		{-0.0888672,3.0293,4.42143},
		{2.10864,0.180664,1.47076},
		{-4.10083,-2.09082,1.55551}};
};
class Land_House_C_10_EP1: Residential
{
	lootPos[] = {
		{-0.476807,-6.18408,-4.2081},{-2.19189,-2.32666,-4.19943},{0.970459,5.15942,-4.19894},{2.09814,8.11133,-4.19852},{0.209961,8.65503,-4.19772},{-1.55542,-2.83594,-0.0197258},{0.849854,-5.49219,-0.869633},{-1.56226,8.49561,-0.878298},{-4.927,0.8396,-0.574228},{-2.1604,8.40674,2.47196},{2.02271,5.81372,5.22763},{-2.17822,1.53076,-0.878794}
	};
	lootPosSmall[] = {
		{-3.52124,-9.30933,-4.20103},{0.401611,-0.616211,-4.19847},{-1.30835,9.25757,-4.11613},{-0.946045,9.29761,-3.10613},{0.183594,9.23438,-2.74583},{1.15552,4.8877,-3.25071},{0.820313,4.84009,-3.58973},{-0.0129395,9.26294,-3.78608},{0.918701,-1.18433,-0.879436},{-2.12231,-2.69775,-0.399366},{-3.64014,4.15503,-0.268515},{-3.17114,0.63916,-0.878897},{2.64014,4.59009,2.47196},{0.853516,5.55664,5.22757},{2.84448,5.5791,2.47196},{3.43945,-9.37354,-0.879139},{1.83667,7.45825,-0.878618},{3.32861,-2.79565,-4.20015}
	};
	zedPos[] = {{0.153076,-2.36743,-3.31192},{-0.96167,-7.51587,-3.32074},{2.4646,5.95142,-3.2957},{-3.10596,6.55762,-3.29418},{2.66089,5.73584,0.00634003},{-1.50708,7.18359,0.00669289},{-0.899902,-4.46045,0.00529861}};
};
class Land_House_L_7_EP1: Residential
{
	lootPos[] = {
		{ 3.52979,-0.34375,0.102112 },
		{ -0.245117,3.10742,-0.261154 },
		{ -5.43408,3.36426,-0.646149 },
		{ -4.90137,1.19189,-0.651993},
		{ 0.214844,-3.70947,-1.00735}};
};
class Land_House_L_6_EP1: Residential
{
	lootPos[] = {
		{ 5.51416,-0.64624,-1.509 },
		{ 1.1626,1.93677,-1.5399 },
		{ 4.20996,1.62158,1.28101 },
		{ 3.15381,-2.12427,1.28099 },
		{ -3.74268,-2.23193,-1.53738 }};
};
class Land_House_K_5_EP1: Residential
{
	lootPos[] = {
		{ -2.40381,1.90674,1.51889 },
		{ -5.96777,0.826416,0.710116 },
		{ -3.05811,4.05676,1.52165 },
		{ 1.29199,1.85913,1.54825 },
		{ 4.40381,3.96619,2.26365 },
		{ 4.17725,0.271484,2.4009 },
		{ 1.30908,1.50195,1.55225 }};
};
class Land_House_L_3_EP1: Residential
{
	lootPos[] = {
		{ -5.59863,-0.384766,-0.173644 },
		{ -5.23425,2.49609,-0.22691 },
		{ 0.75769,2.95508,-0.222477 },
		{ -0.387817,0.0234375,-0.222477 },
		{ 2.11365,2.99512,-0.222477 }};
};
class Land_House_L_4_EP1: Residential
{
	lootPos[] = {
		{ -3.34961,-0.487122,-1.33058 },
		{ -6.60547,0.131348,-1.29852 },
		{ -0.385742,-0.0551758,-1.34066 },
		{ -0.209961,3.14941,-1.253 },
		{ 3.47559,0.370972,-1.05766 },
		{ 5.41992,3.25671,-1.01435 }};
};
class Land_House_L_9_EP1:  Residential
{
	lootPos[] = {
		{ 4.4043,0.311035,-0.621445 },
		{ -2.23584,1.68604,-0.542923 },
		{ 4.0918,0.924805,2.60419}};
};
class Land_House_L_8_EP1: Residential
{
	lootPos[] = {
		{ 0.662598,5.04395,-1.01205 },
		{ 0.73291,2.59424,-1.01574 },
		{ 4.73828,3.56836,-0.773781 },
		{ 3.76758,3.67578,1.73622 },
		{ -2.51514,-2.19971,-1.55013 },
		{ -2.51514,-2.19971,-1.55013 }};
};
class Land_ibrhotel: Residential
{
	lootPos[] = {
		{ -8.44922,9.08105,-7.74672 },
		{ -0.813965,9.1748,-7.74672 },
		{ 3.17383,11.873,-7.74672 },
		{ 2.74072,2.91016,-7.74672 },
		{ 3.80225,-2.44434,-7.85944 },
		{ -1.28711,-0.235352,-4.25943 },
		{ 17.8379,-8.18896,-4.25943 },
		{ 15.4878,-11.4014,-4.25943 },
		{ 11.8403,-17.5391,-4.25943 },
		{ 4.74902,-11.9019,-4.25943 },
		{ -9.04395,-17.6064,-4.25943 },
		{ -11.9761,-15.2539,-4.25943 },
		{ -15.9063,-12.082,-4.25943 },
		{ -12.2837,-4.31934,-4.25943 },
		{ -16.7495,9,-4.25943 },
		{ -15.7764,11.6875,-4.25944 },
		{ -11.9551,16.458,-4.25944 },
		{ -4.83203,12.1294,-4.25943 },
		{ -5.21436,6.14258,-4.25943 },
		{ 3.57373,5.38721,-4.25943 },
		{ 8.66553,17.2417,-4.25943 },
		{ 12.2725,16.1885,-4.25943 },
		{ 11.8359,4.06348,-4.25943 },
		{ 8.99023,1.72949,-4.25943 },
		{ -1.28711,-0.235352,-0.759062 },
		{ 17.8379,-8.18896,-0.759062 },
		{ 15.4878,-11.4014,-0.759062 },
		{ 11.8403,-17.5391,-0.759062 },
		{ 4.74902,-11.9019,-0.759062 },
		{ -9.04395,-17.6064,-0.759062 },
		{ -11.9761,-15.2539,-0.759062 },
		{ -15.9063,-12.082,-0.759062 },
		{ -12.2837,-4.31934,-0.759062 },
		{ -16.7495,9,-0.759062 },
		{ -15.7764,11.6875,-4.25944 },
		{ -11.9551,16.458,-4.25944 },
		{ -4.83203,12.1294,-0.759062 },
		{ -5.21436,6.14258,-0.759062 },
		{ 3.57373,5.38721,-0.759062 },
		{ 8.66553,17.2417,-0.759062 },
		{ 12.2725,16.1885,-0.759062 },
		{ 11.8359,4.06348,-0.759062 },
		{ 8.99023,1.72949,-0.759062 },
		{ -1.28711,-0.235352,2.74082 },
		{ 17.8379,-8.18896,2.74082 },
		{ 15.4878,-11.4014,2.74082 },
		{ 11.8403,-17.5391,2.74082 },
		{ 4.74902,-11.9019,2.74082 },
		{ -9.04395,-17.6064,2.74082 },
		{ -11.9761,-15.2539,2.74082 },
		{ -15.9063,-12.082,2.74082 },
		{ -12.2837,-4.31934,2.74082 },
		{ -16.7495,9,2.74082 },
		{ -15.7764,11.6875,-4.25944 },
		{ -11.9551,16.458,-4.25944 },
		{ -4.83203,12.1294,2.74082 },
		{ -5.21436,6.14258,2.74082 },
		{ 3.57373,5.38721,2.74082 },
		{ 8.66553,17.2417,2.74082 },
		{ 12.2725,16.1885,2.74082 },
		{ 11.8359,4.06348,2.74082 },
		{ -1.54492,0.158691,6.24485 },
		{ 3.11914,5.81445,6.24485 }};
};
class Land_MBG_Shanty_BIG: Residential
{
	lootPos[] = {
		{ -29.8752,-15.8057,2.99997 },
		{ 23.4097,11.5024,24.9672 },
		{ -29.345,-16.7568,3.04013 },
		{ 23.2319,11.6201,27.9672 },
		{ -33.3779,-11.3564,5.81198 }};
};

class Land_Shed_W03_EP1: Residential
{
	maxRoaming = 3;
	lootPos[] = {};
};

class UAZWreck: Residential
{
	zombieClass[] = {"zZombie_Base","z_hunter"};
	zombieChance = 0.3;
	lootChance = 0;
	minRoaming = 1;
	maxRoaming = 2;
	lootPos[] = {};
};