
private [ "_objTarget" , "_bHasKey" , "_iGroupID" ];


// check to see if the global door busy flag is set
if ( !gblbDoorSystemIsBusy ) then {

	// set the flag
	gblbDoorSystemIsBusy = true;

	// get the object handle
	_objTarget = _this select 3;

	// check to see if the door key is in the player key list
	_bHasKey = [ _objTarget ] call fnc_doesPlayerHaveThisKey;

	if ( _bHasKey ) then {

		// clear the setup data for this door set -- get the group ID
		_iGroupID = ( _objTarget getVariable [ "VectorAndID" , [] ] ) select 3;

		// make the call to the routine that invalidates hangar door setup info
		[ _iGroupID ] call fnc_invalidateDoorGroupSetup;

		// declare the public variable
		PVDZEP_ClearObjHangarDoorVarsAndDB = [ _objTarget ];

		// and publish the public variable
		publicVariableServer "PVDZEP_ClearObjHangarDoorVarsAndDB";

		// a message
		titleText [ "You've removed this object from the hangar door system.", "PLAIN DOWN", 3 ];

	} else {

		// a message
		titleText [ "You don't have the key to this door panel.", "PLAIN DOWN", 3 ];
	};

	//  all done -- clear the variable
	gblbDoorSystemIsBusy = false;

} else {

	//a message
	titleText [ "Can't clear door object data right now -- the door system is busy.", "PLAIN DOWN", 3 ];
};






