//
// called from menu option, so the argument list is skewed to take into account the unused two values
//


private [ "_objTarget" , "_bRetVal" , "_argList" , "_bCloseMate" , "_lstDoorData" , "_iGroupID" , "_iMateGroup" , "_bHasKey" , 
	"_lstMatingGroupData" , "_strType" , "_iKeyID" , "_hMainGroupScript" , "_hMateGroupScript" , "_bMateGroupAlreadyClosed" ,
	"_fDoorOpenTime1" , "_fDoorOpenTime2" , "_strKeyDesc" , "_lstGroupData" , "_bIsGroupSetup" , "_lstMateGroupData" , "_bIsMateGroupSetup" ];


// init the return value
_bRetVal = false;

// init the open times
_fDoorOpenTime1 = -9999;
_fDoorOpenTime2 = -9999;

// init the flag for the mate
_bMateGroupAlreadyClosed = true;


// first things first -- check the status of the global door system busy var
if ( !gblbDoorSystemIsBusy ) then {

	// it's not busy, so MAKE it busy!
	gblbDoorSystemIsBusy = true;

	// get the argument list
	_argList = _this select 3;

	// get the door object handle the argument list
	_objTarget = _argList select 0;

	// get the object type
	_strType = typeOf _objTarget;

	// determine if the player has this key
	_bHasKey = [ _objTarget ] call fnc_doesPlayerHaveThisKey;

	// test that value and either continue or bag out
	if ( _bHasKey ) then {

		// the player has the key to this door set

		// get the door data -- this call makes a COPY of the object variable space data into the array
		_lstDoorData = _objTarget getVariable [ "VectorAndID" , [] ];

		// unpack some of the door data
		_iKeyID = _lstDoorData select 2;
		_iGroupID = _lstDoorData select 3;
		_strKeyDesc = _lstDoorData select 4;


		// check to see if this group is setup already. it might have been opened by another player and only set up on another client!
		// set up a pointer to the local copy of the group setup data records
		_lstGroupData = gblLstDoorSetupData select _iGroupID;
		_bIsGroupSetup = _lstGroupData select 0;

		// if this group isn't set up, then we need to set it up while already open!
		if ( _bIsGroupSetup ) then {

			// group IS set up, so verify ownership
			[ _iGroupID ] call fnc_updateOwnership;

		} else{

			// group is NOT set up, so run the setup routine
			[ _strType , _iGroupID , _iKeyID ] call fnc_setupDoorOpsFromTypeGroupKeyWhileOpen;
		};

		// get the amount of time it takes to open this door
		_fDoorOpenTime1 = [ _iGroupID ] call fnc_findDoorMoveTime;

		// a message
		titleText [ format [ "Closing door with %1" , _strKeyDesc ], "PLAIN DOWN", 3 ];

		// go ahead try to close the doors
		_hMainGroupScript = [ _iGroupID ] execVM "HDAS_Client\HangarDoor_closeDoorGroup.sqf";

		// get the close mate flag
		_bCloseMate = _argList select 1;

		// now check the status of the mating door
		if ( _bCloseMate ) then {

			// only do this stuff if we're trying to close the mating door as well

			// find the mate door group ID
			if ( _iGroupID in [1,3,5,7,9] ) then { _iMateGroup = _iGroupID + 1; } else { _iMateGroup = _iGroupID - 1; };

			// get the status record for the mating group
			_lstMatingGroupData = gblLstDoorSetupData select _iMateGroup;

			// retrieve the open/closed group variable from the mating group status record
			_bMateGroupAlreadyClosed = ( ( _lstMatingGroupData select 1 ) == "closed" );

			// check the open thing
			if ( _bMateGroupAlreadyClosed ) then {

				// and print a message
				titleText [ "Mating door is already closed." , "PLAIN DOWN", 3 ];

			} else {

				// check to see if this group is setup already. it might have been opened by another player and only set up on another client!
				// set up a pointer to the local copy of the group setup data records
				_lstMateGroupData = gblLstDoorSetupData select _iMateGroup;
				_bIsMateGroupSetup = _lstMateGroupData select 0;

				// if this group isn't set up, then we need to set it up while already open!
				if ( _bIsMateGroupSetup ) then {

					// group IS set up, so verify ownership
					[ _iMateGroup ] call fnc_updateOwnership;

				} else {

					// group is NOT set up, so call the alternate routine
					[ _strType , _iMateGroup , _iKeyID ] call fnc_setupDoorOpsFromTypeGroupKeyWhileOpen;
				};

				// figure out how long it will take to make the move
				_fDoorOpenTime2 = [ _iMateGroup ] call fnc_findDoorMoveTime;

				// try to close the doors
				_hMateGroupScript = [ _iMateGroup ] execVM "HDAS_Client\HangarDoor_closeDoorGroup.sqf";
			};
		};

	} else {

		// a message
		titleText [ "You don't have the key to this door.", "PLAIN DOWN", 3 ];
	};

	// figure out how long we need to play the sound, and then fire it off
	if ( ( !scriptDone _hMainGroupScript ) || ( !_bMateGroupAlreadyClosed ) ) then {
		
		// figure out which duration is the larger
		if ( _fDoorOpenTime1 < _fDoorOpenTime2 ) then {

			// save the larger of the two
			_fDoorOpenTime1 = _fDoorOpenTime2;
		};

		// call the sound routine
		[ _fDoorOpenTime1 ] call fnc_playDoorSounds;
	};

	// now wait for the doors to close
	while { !scriptDone _hMainGroupScript } do { sleep 0.25; };
	if ( !_bMateGroupAlreadyClosed ) then { while { !scriptDone _hMateGroupScript } do { sleep 0.25; }; };

	// play the door closing clang sound!
	_nul = [ objNull , player , rSAY , "oggDoorsClosing" ] call RE;

	// clear the global busy var
	gblbDoorSystemIsBusy = false;

} else {

	// a message
	titleText [ "Can't close door or doors -- door system is busy.", "PLAIN DOWN", 3 ];
};


// done -- fall through if the return value is a negative

// final return value of a func does NOT have a semicolon
_bRetVal






