//
// called from menu option, so the argument list is skewed to take into account the unused two values
//


private [ "_objTarget" , "_bRetVal" , "_argList" , "_bOpenMate" , "_lstDoorData" , "_iGroupID" , "_iMateGroup" , "_bHasKey" , "_bMatingGroupSetup" , "_bIsMatingGroupOpen" , 
	"_lstMatingGroupData" , "_lstGroupData" , "_bIsGroupSetup" , "_strType" , "_iKeyID" , "_hMainGroupScript" , "_hMateGroupScript" , "_bMateGroupAlreadyOpen" , 
	"_fDoorOpenTime1" , "_fDoorOpenTime2" ];


// init the return value
_bRetVal = false;


// init the open times
_fDoorOpenTime1 = -9999;
_fDoorOpenTime2 = -9999;


// init some values
_bIsGroupSetup = false;
_bMatingGroupSetup = false;


// first things first -- check the status of the global door system busy var
if ( !gblbDoorSystemIsBusy ) then {

	// it's not busy, so MAKE it busy!
	gblbDoorSystemIsBusy = true;

	// get the argument list
	_argList = _this select 3;

	// get the door object handle the argument list
	_objTarget = _argList select 0;

	// get the object type
	_strType = typeOf _objTarget;

	// determine if the player has this key
	_bHasKey = [ _objTarget ] call fnc_doesPlayerHaveThisKey;

	// test that value and either continue or bag out
	if ( _bHasKey ) then {

		// the player has the key to this door set

		// this call makes a COPY of the object variable space data into the array
		_lstDoorData = _objTarget getVariable [ "VectorAndID" , [] ];

		// unpack some of the door data
		_iKeyID = _lstDoorData select 2;
		_iGroupID = _lstDoorData select 3;
		_strKeyDesc = _lstDoorData select 4;

		// check to see if the door group is setup -- make a POINTER into the status record for this group
		_lstGroupData = gblLstDoorSetupData select _iGroupID;
		_bIsGroupSetup = _lstGroupData select 0;

		// make the choice
		if ( _bIsGroupSetup ) then {

			// the groups IS set up, so all we need to do is verify local ownership
			[ _iGroupID ] call fnc_updateOwnership;

		} else {
	
			// the group is NOT set up ( so it must be closed too)!
			// we need to set it up -- make the call to the setup routine, which will also update ownership to improve animation

			_bIsGroupSetup = [ _strType , _iGroupID , _iKeyID ] call fnc_setupDoorOpsFromTypeGroupKey;
		};

		// try to open the doors
		if ( _bIsGroupSetup ) then {

			// get the amount of time it takes to open this door
			_fDoorOpenTime1 = [ _iGroupID ] call fnc_findDoorMoveTime;

			// a message
			titleText [ format [ "Opening door using %1" , _strKeyDesc ], "PLAIN DOWN", 3 ];

			// open the door!
			_hMainGroupScript = [ _iGroupID ] execVM "HDAS_Client\HangarDoor_openDoorGroup.sqf";

		} else {

			// a message
			titleText [ format [ "Error -- Primary door group %1 will not complete door setup." , _iGroupID ], "PLAIN DOWN", 3 ];
		};


		// get the open mate flag
		_bOpenMate = _argList select 1;

		// now check the status of the mating door
		if ( _bOpenMate ) then {

			// only do this stuff if we're trying to open the mating door as well

			// find the mate door group ID
			if ( _iGroupID in [1,3,5,7,9] ) then { _iMateGroup = _iGroupID + 1; } else { _iMateGroup = _iGroupID - 1; };

			// check to see if the mating group is set up -- make a POINTER to the status record for this group
			_lstMatingGroupData = gblLstDoorSetupData select _iMateGroup;
			_bMatingGroupSetup = _lstMatingGroupData select 0;

			// also retrieve the open/closed group variable
			_bMateGroupAlreadyOpen = ( ( _lstMatingGroupData select 1 ) == "open" );
			
			// check the open thing
			if ( _bMateGroupAlreadyOpen ) then {

				// just set the mating setup flag to false
				_bMatingGroupSetup = false;

				// and print a message
				titleText [ "Mating door is already open." , "PLAIN DOWN", 3 ];

			} else {

				// make the choice based on the mating group set up
				if ( _bMatingGroupSetup ) then {

					// the groups IS set up, so all we need to do is update ownership
					[ _iMateGroup ] call fnc_updateOwnership;

				} else {

					// the group is NOT set up ( so it must be closed too)!
					// we need to set it up -- make the call to the setup routine

					// a message
					_bMatingGroupSetup = [ _strType , _iMateGroup , _iKeyID ] call fnc_setupDoorOpsFromTypeGroupKey;
				};
		
				// try to open the doors
				if ( _bMatingGroupSetup ) then {

					// figure out how long it will take to make the move
					_fDoorOpenTime2 = [ _iMateGroup ] call fnc_findDoorMoveTime;

					// and try to open the mating doors
					_hMateGroupScript = [ _iMateGroup ] execVM "HDAS_Client\HangarDoor_openDoorGroup.sqf";

				} else {
	
					// a message
					// this message will eventually go away when code is final
					titleText [ format [ "Error -- Mating door group %1 will not complete door setup." , _iMateGroup ], "PLAIN DOWN", 3 ];
				};
			};
		};


	} else {

		// a message
		titleText [ "You don't have the key to this door.", "PLAIN DOWN", 3 ];
	};

	// figure out how long we need to play the sound, and then fire it off
	if ( _bIsGroupSetup || _bMatingGroupSetup ) then {
		
		// figure out which duration is the larger
		if ( _fDoorOpenTime1 < _fDoorOpenTime2 ) then {

			// save the larger of the two
			_fDoorOpenTime1 = _fDoorOpenTime2;
		};

		// call the sound routine
		[ _fDoorOpenTime1 ] call fnc_playDoorSounds;
	};

	// now wait for the doors to open
	if ( _bIsGroupSetup ) then { while { !scriptDone _hMainGroupScript } do { sleep 0.5; }; };
	if ( _bMatingGroupSetup ) then { while { !scriptDone _hMateGroupScript } do { sleep 0.5; }; };


	// clear the global busy var
	gblbDoorSystemIsBusy = false;

} else {

	// a message
	titleText [ "Can't open door or doors -- door system is busy.", "PLAIN DOWN", 3 ];
};


// done -- fall through if the return value is a negative

// final return value of a func does NOT have a semicolon
_bRetVal






