// 
//
// 


private [ "_iGroupID" , "_lstStatusRecord" , "_fStartTimeSecs" , "_fTimeNowSecs" , "_fXMoveNow" , "_fYMoveNow" , "_fXNow" , "_fYNow" , "_lstDoors" , "_bAreClosed" , 
	"_fdist" , "_fUnitX" , "_fUnitY" , "_fElapsedTime" , "_fRequiredMoveTime" , "_bLastMove" , "_fDistToMove" , "_iindex" , "_lstTempLoc" , "_lstOrigCenters" , 
	"_lstOpenCenters" ];


// get the group to open from the parameter list
_iGroupID = _this select 0;

// init a variable
_bAreClosed = false;

// get a POINTER to the status record for this group
_lstStatusRecord = gblLstDoorSetupData select _iGroupID;

// get a POINTER to the list of door object handles
_lstDoors = _lstStatusRecord select 3;

// get the distance we need to move
_fdist = _lstStatusRecord select 4;

// get the unit vector components we need to move
_fUnitX = _lstStatusRecord select 5;
_fUnitY = _lstStatusRecord select 6;

// get POINTERS to the lists of center points for the objects in the group
_lstOrigCenters = _lstStatusRecord select 7;
_lstOpenCenters = _lstStatusRecord select 8;


// get the time at which we're starting this script
_fStartTimeSecs = serverTime;

// get the required move time
_fRequiredMoveTime = _fdist / gblfHangarDoorMoveRate;

// iterate through time until the doors are fully closed
while { !_bAreClosed } do {

	// get the time NOW
	_fTimeNowSecs = serverTime;

	// figure out the elapsed time since the beginning of the script run
	_fElapsedTime = _fTimeNowSecs - _fStartTimeSecs;

	// are we on the last move frame?
	_bLastMove = ( _fElapsedTime > _fRequiredMoveTime );

	// so make some decisions based on that -- figure out how far the door segments will move
	if ( _bLastMove ) then {

		_fDistToMove = _fdist;
		_bAreClosed = true;

	} else {

		_fDistToMove = 	gblfHangarDoorMoveRate * _fElapsedTime;

	};

	// now calculate the vector components
	_fXNow = _fDistToMove * _fUnitX;
	_fYNow = _fDistToMove * _fUnitY;
	
	// zero the index
	_iindex = 0;

	// now iterate through the doors
	{
		// what we do depends on whether we're on the last move or not
		if ( _bLastMove ) then {

			// it's the last move, so we need to COPY the original closed position already saved into the temporary location array
			_lstTempLoc = +( _lstOrigCenters select _iindex );
		
		} else {

			// NOT the last move, so we figure the incremental distance based on movement rate

			// start with a COPY of the original open location of the door
			_lstTempLoc = +( _lstOpenCenters select _iindex );

			// increment the coords by how far we've had to move at this time
			_lstTempLoc set [ 0 , ( ( _lstTempLoc select 0 ) - _fXNow ) ];
			_lstTempLoc set [ 1 , ( ( _lstTempLoc select 1 ) - _fYNow ) ];

		};

		// and set the positon of the object to that location ASL
		_x setPosASL _lstTempLoc;

		// lastly, increment the index
		_iindex = _iindex + 1;

	} forEach _lstDoors;

	// a delay so that the loop doesn't run away with system resources!
	sleep 0.05;
};


// update the status record to "close"
_lstStatusRecord set [ 1 , "closed" ];

// now put the local copy of the door group status record back into the big persistent list -- NOT NECESSARY SINCE _lstStatusRecord is a pointer
//gblLstDoorSetupData set [ _iGroupID , _lstStatusRecord ];

// and the last thing we do is mark the entire group as open
[ _iGroupID , "closed" ] call fnc_markAllDoorSegsOfGroup;

// we are done here!