// 
//
// 

private [ "_iGroupID" , "_lstStatusRecord" , "_fStartTimeSecs" , "_fTimeNowSecs" , "_fXMoveNow" , "_fYMoveNow" , "_fXNow" , "_fYNow" , "_lstDoors" , "_bAreOpen" , 
	"_fdist" , "_fUnitX" , "_fUnitY" , "_fElapsedTime" , "_fRequiredMoveTime" , "_bLastMove" , "_fDistToMove" , "_iindex" , "_lstTempLoc" , "_lstOrigCenters" , 
	"_lstOpenCenters" ];


// get the group to open from the parameter list
_iGroupID = _this select 0;

// init a variable
_bAreOpen = false;

// get a pointer to this group's the status record
_lstStatusRecord = gblLstDoorSetupData select _iGroupID;

// get the list of door object handles
_lstDoors = _lstStatusRecord select 3;

// get the distance we need to move
_fdist = _lstStatusRecord select 4;

// get the unit vector components we need to move
_fUnitX = _lstStatusRecord select 5;
_fUnitY = _lstStatusRecord select 6;

// get pointers to the lists of door seg center locations
_lstOrigCenters = _lstStatusRecord select 7;
_lstOpenCenters = _lstStatusRecord select 8;

// get the time at which we're starting this script
_fStartTimeSecs = serverTime;

// get the required move time
_fRequiredMoveTime = _fdist / gblfHangarDoorMoveRate;

// iterate through time until the doors are fully open
while { !_bAreOpen } do {

	// get the time NOW
	_fTimeNowSecs = serverTime;

	// figure out the elapsed time since the beginning of the script run
	_fElapsedTime = _fTimeNowSecs - _fStartTimeSecs;

	// are we on the last move frame?
	_bLastMove = ( _fElapsedTime > _fRequiredMoveTime );

	// so make some decisions based on that -- figure out how far the door segments will move
	if ( _bLastMove ) then {

		_fDistToMove = _fdist;
		_bAreOpen = true;

	} else {

		_fDistToMove = gblfHangarDoorMoveRate * _fElapsedTime;

	};

	// now calculate the vector components
	_fXNow = _fDistToMove * _fUnitX;
	_fYNow = _fDistToMove * _fUnitY;

	// zero the index
	_iindex = 0;

	// now iterate through the doors
	{
		// COPY the original center location for this door into a temporary array
		_lstTempLoc = +( _lstOrigCenters select _iindex );

//////
//titleText [ format [ "STATUS #Z: HangarDoor_openDoorGroup.sqf Origin: %1 , %2 -- Moving dx:%3 dy:%4" , (_lstTempLoc select 0 ) , (_lstTempLoc select 1) , _fXNow , _fYNow ] , "PLAIN DOWN", 1 ];
//////

		// increment the coords
		_lstTempLoc set [ 0 , ( ( _lstTempLoc select 0 ) + _fXNow ) ];
		_lstTempLoc set [ 1 , ( ( _lstTempLoc select 1 ) + _fYNow ) ];


		// and set the positon of the object to that location ASL
		_x setPosASL _lstTempLoc;

		// save the last position in the second list if this is the last move
		if ( _bLastMove ) then {
			
			// set a COPY of the the updated posASL vector into into the second list at the same index
			_lstOpenCenters set [ _iindex , ( +_lstTempLoc ) ];
		};

		// lastly, increment the index
		_iindex = _iindex + 1;

	} forEach _lstDoors;

	// a delay so this loop doesn't fly!
	sleep 0.05;
};


// stash the list of new centers at the open positions back into the status record for this door set ( this shouldn't be necessary because _lstOpenCenters is a POINTER.... )
//_lstStatusRecord set [ 8 , _lstOpenCenters ];

// update the status record to "open"
_lstStatusRecord set [ 1 , "open" ];

// now put the local copy of the door group status record back into the big persistent list ( again, this shouldn't be necessary because we're dealing with pointers.... )
//gblLstDoorSetupData set [ _iGroupID , _lstStatusRecord ];


// and the last thing we do is mark the entire group as open
[ _iGroupID , "open" ] call fnc_markAllDoorSegsOfGroup;

// we are done here!