

private [ "_argList" , "_objTarget" , "_iGroupID" , "_fHeading" , "_keyval" , "_bDoorsOtherKey" , "_iMateGroup" , "_bMatingDoorsOtherKey" , "_strKeyDesc" , "_bAnyOtherInGroup" , 
	"_bHasWheel" , "_bHasParts" , "_bHasEngine" , "_lstMagazines" ];


// check the status of the global door busy variable
if ( !gblbDoorSystemIsBusy ) then {

	// it wasn't busy, so make it busy
	gblbDoorSystemIsBusy = true;

	// get the argument list
	_argList = _this select 3;

	// unpack the argument list
	_objTarget 	= _argList select 0;
	_iGroupID 		= _argList select 1;
	_fHeading 		= _argList select 2;
	_keyval 		= _argList select 3;
	_strKeyDesc 	= _argList select 4;


	// look to see if ANY OTHER objects of this type exist within the search range that were defined with a DIFFERENT primary key ...
	_bDoorsOtherKey = [ ( typeOf _objTarget ) , _iGroupID , _keyval ] call fnc_findObjectsOfTypeGroupWrongKey;

	// look to see if ANY OTHER objects of this type exist within the search range at all
	_bAnyOtherInGroup = [ ( typeOf _objTarget ) , _iGroupID ] call fnc_findObjectsOfTypeGroup;


	// find the mating group
	if ( _iGroupID in [1,3,5,7,9] ) then { _iMateGroup = _iGroupID + 1; } else { _iMateGroup = _iGroupID - 1; };


	// are there doors in the MATING group that use a different key???
	_bMatingDoorsOtherKey = [ ( typeOf _objTarget ) , _iMateGroup , _keyval ] call fnc_findObjectsOfTypeGroupWrongKey;


	// use it
	if ( _bDoorsOtherKey ) then {

		// uh oh! there are other door segments defined in this group with a different keyval! can't do that!
		titleText [ "Cannot define door segment. There are other door panels in this group using a different key!", "PLAIN DOWN", 3 ];

	} else {

		// check to see if there's a problem with MATING door key use..
		if ( _bMatingDoorsOtherKey ) then {

			// uh oh! there are other door segments defined in the MATING group with a different keyval! can't do that!
			titleText [ "Cannot define door segment. There are other mating group door panels defined with a different key!", "PLAIN DOWN", 3 ];
		
		} else {

			// find the parts
			_lstMagazines = magazines player;

			_bHasWheel = ( "PartWheel" in _lstMagazines );
			_bHasParts = ( "PartGeneric" in _lstMagazines );

			// if there is already one of these group, we don't need an engine 
			if ( _bAnyOtherInGroup ) then {
				_bHasEngine = true;
			} else {
				_bHasEngine = ( "PartEngine" in _lstMagazines );
			};

			if ( ( !_bHasWheel ) || ( !_bHasParts ) || ( !_bHasEngine ) ) then {
	
				// we don't have the required parts ... bag out
				if ( _bAnyOtherInGroup ) then {
					// just the two parts
					titleText [ "Cannot proceed. You need a Tire and some Scrap Metal to add this object to a door.", "PLAIN DOWN", 3 ];
				} else {
					// all three parts required
					titleText [ "Cannot proceed. You need Engine Parts, a Tire, and some Scrap Metal to start a door group.", "PLAIN DOWN", 3 ];
				};

			} else {

				// we can proceed ....  set the door's variable to closed
				_objTarget setVariable [ "OpenOrClosed" , "closed" , true ];

				// invalidate the stashed/precalculated setup information, if any
				[ _iGroupID  ] call fnc_invalidateDoorGroupSetup; 
	
				// declare the public variable
				PVDZEP_CreateObjHangarDoorAndSaveToDB = [ _objTarget , _iGroupID , _fHeading , _keyval , _strKeyDesc ];

				// and publish the public variable
				publicVariableServer "PVDZEP_CreateObjHangarDoorAndSaveToDB";

				// a message
				titleText [ format [ "Object defined as door segment in group %1 using key %2." , _iGroupID , _strKeyDesc ] , "PLAIN DOWN", 3 ];

				// remove the items from inventory
				player removeMagazine "PartWheel";
				player removeMagazine "PartGeneric";
				if ( !_bAnyOtherInGroup ) then {
					player removeMagazine "PartEngine";
				};
			};
		};
	};

	// done here, so clear the flag
	gblbDoorSystemIsBusy = false;

} else {

	// a message
	titleText [ "Cannot define door segment. The hangar door system is busy right now.", "PLAIN DOWN", 3 ];
};




