

private [ "_objDoorSegment" , "_fHeading" , "_keyval" , "_totalkeys" , "_doorOpenOrClosed" , "_strKeyDesc" , "_strObjectID" ];


// get the vehicle handle
_objDoorSegment = _this select 3;

// remove the hangar door options from the menu
{ gblObjLastHangarDoor removeAction _x } forEach gblListHangarDoorOptions;

// empty the array of menu action indices
gblListHangarDoorOptions = [];

// set the global flag equal to the input parameter vehicle handle
gblObjLastHangarDoor = _objDoorSegment;


// check to see if the player has any keys -- if there are no keys, we can't do ANYTHING with hangar doors -- jump directly to REMOVE the menu items code
_totalKeys = call epoch_tempKeys;			// Returns array: [["11148","1457"],["Black Key (2eb5)","Green Key (9c30)"],[<lst if itemclassIDs>]]

// check to see if the player's ID matches the build ID on the doors -- can't do ANYTHING with these doors with a mismatch
_strObjectID = player getVariable [ "CharacterID" , "A" ];

if ( ( ( count ( _totalKeys select 0 ) ) > 0 ) && ( dayz_characterID == _strObjectID ) ) then {

	// we have some keys, so do something...

	// figure out the status of the Hangar Door NOW and set up the options accordingly ....

	_doorOpenOrClosed = _objDoorSegment getVariable [ "OpenOrClosed" , "undefined" ];

	// if door is UNDEFINED, only action possible is to DEFINE door, which means we add it to a group ID
	// if door is OPEN, only action possible is to CLOSE door
	// if door is CLOSED, actions are verify, open, or clear


	// so we have a key and we can proceed -- first check to see if it's an UNDEFINED state, which means all we can do is define a door segment

	if ( _doorOpenOrClosed == "undefined" ) then {

		// get the player heading
		_fHeading = getDir player;

		// get the value of the FIRST key in the inventory and turn it into a number instead of a string
		_keyval = floor ( parseNumber ( _totalKeys select 0 select 0 ) + 0.5 );

		// get the key string as well
		_strKeyDesc = _totalKeys select 1 select 0;

		// add the definition options

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to LEFT Hangar Door 1", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 1 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to RIGHT Hanger Door 2", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 2 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to LEFT Hanger Door 3", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 3 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to RIGHT Hanger Door 4", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 4 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to LEFT Hanger Door 5", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 5 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to RIGHT Hanger Door 6", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 6 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to LEFT Hanger Door 7", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 7 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to RIGHT Hanger Door 8", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 8 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to LEFT Hanger Door 9", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 9 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["Add to RIGHT Hanger Door 10", "HDAS_Client\HangarDoorsWriteValuesToDB.sqf" , [ gblObjLastHangarDoor , 10 , _fHeading , _keyval , _strKeyDesc ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [count gblListHangarDoorOptions , _actionhandleTemp];

	};

	// next, check to see if the door is OPEN

	if ( _doorOpenOrClosed == "open" ) then {

		_actionhandleTemp = gblObjLastHangarDoor addAction ["CLOSE this hangar door", "HDAS_Client\HangarDoor_Close.sqf" , [ gblObjLastHangarDoor , false ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["CLOSE this hangar door and its mate, if any", "HDAS_Client\HangarDoor_Close.sqf" , [ gblObjLastHangarDoor , true ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];
	};


	// finally, check to see if the door is CLOSED

	if ( _doorOpenOrClosed == "closed" ) then {

		_actionhandleTemp = gblObjLastHangarDoor addAction ["OPEN this hangar door", "HDAS_Client\HangarDoor_Open.sqf" , [ gblObjLastHangarDoor , false ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["OPEN this hangar door and its mate, if any", "HDAS_Client\HangarDoor_Open.sqf" , [ gblObjLastHangarDoor , true ] , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["VERIFY this door's ID", "HDAS_Client\HangarDoorsTestEchoValues.sqf" , gblObjLastHangarDoor , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];

		_actionhandleTemp = gblObjLastHangarDoor addAction ["CLEAR hangar door settings from this object", "HDAS_Client\HangarDoor_Clear.sqf" , gblObjLastHangarDoor , 0, false, true, "",""];
		gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];

	};

} else {

	// a message
	titleText [ "You need a key to do this, or you are not the builder of this object.", "PLAIN DOWN", 3 ];
};


 
// always add the cancel option that gets us back to the basic menu state
_actionhandleTemp = gblObjLastHangarDoor addAction [ "Cancel Hangar Door Options", "HDAS_Client\HangarDoors_CancelOptions.sqf" , gblObjLastHangarDoor , 0, false, false, "",""];
gblListHangarDoorOptions set [ count gblListHangarDoorOptions , _actionhandleTemp ];


// set the flag
gblbHangarDoorOptControl = 1;
