//
// usage after compilation
//
// _bBool = [ _objHandle ] call fnc_doesPlayerHaveThisKey;
//

private [ "_bRetValue" , "_objDoorPanel" , "_lstDoorData" , "_iDoorKey" , "_strDoorkey" , "_lstKeyList" , "_lstKeyValues" ];

// init return value
_bRetValue = false;


// first, get the key from the door and turn it into a string

// get the handle to the door object
_objDoorPanel = _this select 0;

// get the door's data that contains the key ID in int form
_lstDoorData = [];
_lstDoorData = _objDoorPanel getVariable [ "VectorAndID" , [] ];

// check to see if we have elements just to avoid an error -- this routine shouldn't be called unless we've verified this is already a door segment
if ( ( count _lstDoorData ) > 0 ) then {

	// get the int door key value
	_iDoorKey = _lstDoorData select 2;

	// convert that into a string
	_strDoorkey = str _iDoorKey;

	// now get the list of keys the player has in primary and backpack inventories
	_lstKeyList = call epoch_tempKeys;

	// epoch_tempkeys will always return a list of three empty lists, if there are no keys -- so the primary list will always have nonzero count
	// get the list of string key digit values
	_lstKeyValues = _lstKeyList select 0;

	// now see if the string test key is in there
	_bRetValue = _strDoorkey in _lstKeyValues;
};

// done -- fall through if the return value is a negative

// final return does NOT have a semicolon
_bRetValue






