//
// usage after compilation
//
// array[ min , max ] = [ fFrameOriginX , fFrameOriginY , fXaxisX , fXaxisY , lstArrayOfCoords[x,y] ] call fnc_findMinMaxProjectedOntoFrameXAxis;
//

private [ "_lstWorldPoints" , "_fFrameOX" , "_fFrameOY" , "_fXvecX" , "_fXvecY" , "_fYvecX" , "_fYvecY" , "_lstWorldPoints" , "_fTestMin" , "_fTestMax" ,
	"_fIFrameOX" , "_fIXvecX" , "_fIYvecX" , "_fTempDet" , "_fFrameX" ];

// init return value

_lstRetVals = [ 0 , 0 ];


// unpack the parameter list

_fFrameOX = _this select 0;
_fFrameOY = _this select 1;
_fXvecX = _this select 2;
_fXvecY = _this select 3;
_lstWorldPoints = _this select 4;


// set a safe test min and max

_fTestMin = 1e20;
_fTestMax = -1e20;


// build the y-vector for the frame, which is the x-vector rotated 90 deg CCW

_fYvecX = -_fXvecY;
_fYvecy =  _fXvecX;


// now build the inverse frame elements we need to move points into the frame of the door

_fTempDet = _fXvecX * _fYvecY - _fXvecY * _fYvecX;

_fIXvecX =  _fYvecY / _fTempDet;
_fIYvecX = -_fYvecX / _fTempDet;
_fIFrameOX = ( _fYvecX * _fFrameOY - _fYvecY * _fFrameOX ) / _fTempDet;


// now traverse through all the points in the input array

{

	// convert the test point's x-coord only into the frame represented by the Point and X-vector

	_fFrameX = _fIXvecX * ( _x select 0 ) + _fIYvecX * ( _x select 1 ) + _fIFrameOX;

	// check it
	
	if ( _fFrameX < _fTestMin ) then { _fTestMin = _fFrameX; };
	if ( _fFrameX > _fTestmax ) then { _fTestMax = _fFrameX; };
	
} forEach _lstWorldPoints;


// done here

_lstRetVals set [ 0 , _fTestMin ];
_lstRetVals set [ 1 , _fTestmax ];


// final return does NOT have a semicolon
_lstRetVals



