//
// usage after compilation
//
// _bRetValue = [ "classIDtext" , _intGroupID ] call fnc_findObjectsOfTypeGroup;
//

private [ "_bRetValue" , "_strType" , "_iGroupID" , "_lstTemp" , "_lstDoorData" , "_iThisID" ];

// init return value
_bRetValue = false;


// get the arguments
_strType = _this select 0;
_iGroupID = _this select 1;

// make a temporary list -- this call copies information to an array
_lstTemp = position player nearObjects [ _strType , gblfDoorSegmentSearchRange ];

// now for each the elements of the temp list that match the specified group ID, figure out if this is an EARLIER db entry...
{
	// get the list of data from the object -- this call COPIES data into an array
	_lstDoorData = _x getVariable [ "VectorAndID" , [] ];

	// check the list -- if it's nil, skip over it
	if ( !isNIl "_lstDoorData" ) then {
	
		// now check to see if that's defined
		if ( ( count _lstDoorData ) > 3 ) then {

			// there's at least 4 data points in there -- must be a door segment -- get the door group ID
			_iThisID = _lstDoorData select 3;

			// check to see if the group IDs match:
			if ( _iGroupID == _iThisID ) then {

				// found a match! an object of the test type and the test group already exists
				_bRetValue = true;
			};
		};
	}; 

} forEach _lstTemp;


// done -- fall through if the return value is a negative

// the last line of a function is the return value -- no semicolon!
_bRetValue
