//
// usage after compilation
//
// _bRetValue = [ "classIDtext" , _intGroupID , _intKey ] call fnc_findObjectsOfTypeGroupWrongKey;
//

private [ "_bRetValue" , "_strType" , "_iGroupID" , "_iKeyID" , "_lstTemp" , "_lstDoorData" , "_iThisID" , "_iThisKey" ];

// init return value
_bRetValue = false;


// get the arguments
_strType = _this select 0;
_iGroupID = _this select 1;
_iKeyID = _this select 2;


//////
//titleText [ ( "Object type is " + _strType ) , "PLAIN DOWN", 3 ];
//sleep 2;


// make a temporary list -- this call copies information to an array
_lstTemp = position player nearObjects [ _strType , gblfDoorSegmentSearchRange ];


//////
//titleText [  format [ "object List contents number %1" , ( count _lstTemp ) ] , "PLAIN DOWN", 3 ];
//sleep 2;


// now for each the elements of the temp list that match the specified group ID, figure out if this is an EARLIER db entry...
{
	// get the list of data from the object -- this call COPIES data into an array
	_lstDoorData = _x getVariable [ "VectorAndID" , [] ];

	// check the list -- if it's nil, skip over it
	if ( !isNIl "_lstDoorData" ) then {
	
		// now check to see if that's defined
		if ( ( count _lstDoorData ) > 3 ) then {

			// there's at least 4 data points in there -- must be a door segment -- get the key and the door group ID
			_iThisKey = _lstDoorData select 2;
			_iThisID = _lstDoorData select 3;

			// check to see if the group IDs match:
			if ( ( _iGroupID == _iThisID ) && ( _iKeyID != _iThisKey ) )  then {

				// found a mismatch! an object of the test type and the test group, but with a WRONG key!
				_bRetValue = true;
			};
		};
	}; 

} forEach _lstTemp;


// done -- fall through if the return value is a negative

// the last line of a function is the return value -- no semicolon!
_bRetValue
