//
// usage after compilation
//
// _array[ xdir , ydir ] = [ _objHandle ] call fnc_findOpenDirection;
//

private [ "_lstRetDir" , "_objDoorPanel" , "_lstDoorData" , "_fPlayerHdgX" , "_fPlayerHdgY" , "_fDoorHeading" , "_fDoorHdgX" , "_fDoorHdgY" , "_fDoorRiteX" , "_fDoorRiteY", 
	"_iGroupID" , "_fPlayerRiteX" , "_fPlayerRiteY" , "_fPlyrRtDotDoorRt" , "_fPlyrRtDotDoorHdg" , "_bPlyrRtDotDoorRtNeg" , "_bPlyrRtDotDoorHdgNeg" , 
	"_bDoorIsOdd" , "_foutX" , "_foutY" ];

// init return value
_lstRetDir = [ -1 , 0 ];

// get the door from the argument list
_objDoorPanel = _this select 0;

// now get the player heading set at the time the door was created
_lstDoorData = _objDoorPanel getVariable [ "VectorAndID" , [] ];

// check to see if we have elements just to avoid an error -- this routine shouldn't be called unless we've verified this is already a door segment
if ( ( count _lstDoorData ) > 3 ) then {

	// looks like we do -- these values are the facing vector in x-y
	_fPlayerHdgX = ( _lstDoorData select 0 ) / 1000;
	_fPlayerHdgY = ( _lstDoorData select 1 ) / 1000;

	// now we need to find the heading vector for the door segment ....

	// get the heading angle wrt north	
	_fDoorHeading = getDir _objDoorPanel;

	// make the same x-y dir vector calcs from the door segment heading angle
	_fDoorHdgX = sin _fDoorHeading;
	_fDoorHdgY = cos _fDoorHeading;

	// now the problem is to find which door axis is most closely aligned with the target player LEFT or RIGHT
	
	// get the GROUP ID of the door segment
	_iGroupID = _lstDoorData select 3;

	// now figure out if the door opens LEFT or RIGHT
	_bDoorIsOdd = ( _iGroupID in [ 1 , 3 , 5 , 7 , 9 ] );

	// find the vector to player RIGHT, that vector being the player heading rot 90 CW
	_fPlayerRiteX =  _fPlayerHdgY;
	_fPlayerRiteY = -_fPlayerHdgX;


	// now find the vector to DOOR RIGHT, that vector being the door heading rot 90 CW
	_fDoorRiteX =  _fDoorHdgY;
	_fDoorRiteY = -_fDoorHdgX;


	// find the dot products between player right and door right, and between player right and door heading

	_fPlyrRtDotDoorRt  = _fPlayerRiteX * _fDoorRiteX + _fPlayerRiteY * _fDoorRiteY;
	_fPlyrRtDotDoorHdg = _fPlayerRiteX * _fDoorHdgX  + _fPlayerRiteY * _fDoorHdgY;

	if ( ( abs _fPlyrRtDotDoorRt ) > ( abs _fPlyrRtDotDoorHdg ) ) then {

		// ok, this means that the intended player right-left is more closely aligned with the door x-axis

		if ( _bDoorIsOdd ) then {

			// the door should move to the LEFT as indicated by player position, and the door left-right is aligned with player left-right

			if ( _fPlyrRtDotDoorRt > 0 ) then {

				// and the player left-right and door left-right are generally in the same direction, too ... so we use the DOOR LEFT, which is the opposite of DOOR RIGHT

				_foutX = -_fDoorRiteX;
				_foutY = -_fDoorRiteY;

			} else {

				// but the player left-right and the door left-right are generally opposed, which means a move LEFT is actually the door's RIGHT frame vector

				_foutX = _fDoorRiteX;
				_foutY = _fDoorRiteY;
			};

		} else {

			// the door should move to the RIGHT as indicated by player position, and the door left-right is aligned with player left-right

			if ( _fPlyrRtDotDoorRt > 0 ) then {

				// and the player left-right and door left-right are generally in the same direction, too ... so RIGHT means we use straight DOOR RIGHT vector

				_foutX = _fDoorRiteX;
				_foutY = _fDoorRiteY;

			} else {

				// but the player left-right and the door left-right are generally opposed, which means a move RIGHT is actually opposite the door's RIGHT frame vector

				_foutX = -_fDoorRiteX;
				_foutY = -_fDoorRiteY;
			};
		};

	} else {

		// whereas if we get here, this means that the intended player right-left is more closely aligned with the door y-axis

		if ( _bDoorIsOdd ) then {

			// the door should move to the LEFT as indicated by player position, and the door -y/+y is aligned with the player's LEFT-RIGHT

			if ( _fPlyrRtDotDoorHdg > 0 ) then {

				// ... and the player's RIGHT direction is best aligned with the door's +y, which means we need to use the opposite of the heading vector

				_foutX = -_fDoorHdgX;
				_foutY = -_fDoorHdgY;

			} else {

				// this case covers when the player's RIGHT is pretty much OPPOSITE to the door's +y, which means we need to use LEFT set equal to the heading vector

				_foutX = _fDoorHdgX;
				_foutY = _fDoorHdgY;
			};

		} else {

			// the door should move to the RIGHT as indicated by player position, and the door's -y/+y is aligned with the player's LEFT-RIGHT

			if ( _fPlyrRtDotDoorHdg > 0 ) then {

				// ... and the player's RIGHT direction is best aligned with the door's +y, which means we need to use the the heading vector itself

				_foutX = -fDoorHdgX;
				_foutY = -fDoorHdgY;

			} else {

				// this case covers when the player's RIGHT is pretty much OPPOSITE to the door's +y, which means we need to use RIGHT set opposite to the heading vector

				_foutX = -_fDoorHdgX;
				_foutY = -_fDoorHdgY;
			};
		};
	};

	// and that's all folks -- just set up the return array

	_lstRetDir set [ 0 , _foutX ];
	_lstRetDir set [ 1 , _foutY ];

};

// done -- fall through if the return value is a negative

// final return value of a func does NOT have a semicolon
_lstRetDir






