//
// usage after compilation
//
// [ _iGroupID ] call fnc_invalidateDoorGroupSetup;
//

private [ "_iGroupID" , "_lstObjectsInGroup" , "_iEHIndex" ];

// get the group ID from the parameter list
_iGroupID = _this select 0;

// get the list of objects in the group's setup record
_lstObjectsInGroup = gblLstDoorSetupData select _iGroupID select 3;

// iterate through the objects
{
	_iEHIndex = _x getVariable [ "DeletedEHIndex" , -999 ];

	// look at that value
	if ( _iEHIndex != -999 ) then {
			
		// if the handler exists, we need to nuke the event handler from this object
		_x removeEventHandler [ "Deleted" , _iEHIndex ];

		// and we also need to remove any trace of the index being saved in the object's variable space
		_x setVariable [ "DeletedEHIndex" , nil , true ];
	};

	_iEHIndex = _x getVariable [ "KilledEHIndex" , -999 ];

	// look at that value
	if ( _iEHIndex != -999 ) then {
			
		// if the handler exists, we need to nuke the event handler from this object
		_x removeEventHandler [ "killed" , _iEHIndex ];

		// and we also need to remove any trace of the index being saved in the object's variable space
		_x setVariable [ "KilledEHIndex" , nil , true ];
	};

} forEach _lstObjectsInGroup;

// finally, nuke the global setup data's record
gblLstDoorSetupData set [ _iGroupID , (+gblListDoorStatus) ];	


// we are done here
