//
// this routine sets up a hangar door the first time it's used in the game on one client
//
// it builds the list of participating door objects, the direction in which it opens, a flag indicating whether or not it's set up, and the total distance it has to move
//
// usage after compilation
//
// _bRetVal = [ "classIDtext" , _intGroupID , _intKey ] call fnc_setupDoorOpsFromTypeGroupKey;
//

private [ "_bRetVal" , "_lstAllObjects" , "_lstAllCenters" , "_strType" , "_iGroupID" , "_iKeyID" , "_lstTemp" , "_lstDoorData" , "_iThisID" , "_iThisKey" , 
	"_iThisIdx" , "_objectID" , "_objectUID" , "_iTestValue" , "_lstSetupTemp" , "_lstTempVec" , "_lstTempExtents" , "_lstTempCoords" , "_iEHIndex" , 
	"_iCtrIdx" ];


// init the list used to stash handles to all return values
_lstAllObjects = [];

// init the list of all object centers for processing
_lstAllCenters = [];
_lstThisCenter = [];

// init the return value
_bRetVal = false;

// get the arguments
_strType = _this select 0;
_iGroupID = _this select 1;
_iKeyID = _this select 2;

// make a temporary list -- this call COPIES information into a pointer-referenced array
_lstTemp = position player nearObjects [ _strType , gblfDoorSegmentSearchRange ];

// initialize a very large value
_iThisIdx = 1e38;

// initialize a status record as a COPY of the gbl default status record
_lstSetupTemp = +gblListDoorStatus;

// throw an error message if the init doesn't work!
if ( ( count _lstSetupTemp ) < 8 ) then {

	titleText [ "UH OH! The unary array copy operator doesn't work as expected!!!!" , "PLAIN DOWN", 3 ];
	sleep 20;
};

// now for each the elements of the temp list that match the specified group ID, figure out if this is an EARLIER db entry...
{
	// get the list of data from the object -- this call COPIES data from the variable space of the object into the array
	_lstDoorData = _x getVariable [ "VectorAndID" , [] ];
	
	// now check to see if that's defined
	if ( ( count _lstDoorData ) > 3 ) then {

		// there's at least 4 data points in there -- must be a door segment -- get the key and the door group ID
		_iThisKey = _lstDoorData select 2;
		_iThisID = _lstDoorData select 3;

		// check to see if the group IDs match:
		if ( ( _iGroupID == _iThisID ) && ( _iKeyID == _iThisKey ) )  then {

			// a match -- set the return flag to true
			_bRetVal = true;

			// a match -- there's going to be valid setup information for this setup record
			_lstSetupTemp set [ 0 , true ];
			_lstSetupTemp set [ 1 , "closed" ];


			// a match -- phase I -- this object has the right type and group ID and keyset -- put this one into the persistent group
			_lstAllObjects set [ ( count _lstAllObjects ) , _x ];


			// a match -- phase II -- now get the data base index values from this object
			_objectID = _x getVariable [ "ObjectID" , "0" ];
			_objectUID = _x getVariable [ "ObjectUID" , "0" ];

			// if the object is NEW, then the primary key won't be available within the game yet -- all we have is the generated UID
			if ( _objectID == "0" ) then {
	
				// a new object -- compare the UID instead of the primary index ID -- and remember the object IDs come in as STRINGS!
				_iTestValue = parseNumber _objectUID;

			} else {

				// an object already in the db with a valid primary key retrieved into object variable space during object stream-in
				_iTestValue = parseNumber _objectID;
			};

			// now test the value
			if ( _iTestValue < _iThisIdx ) then {
				
				// found a new, earlier object ( or the first object that matches criteria )
				// save he new test index
				_iThisIdx = _iTestValue;

				// and stash the object handle in the outgoing variable
				_lstSetupTemp set [ 2 , _x ];
			};


			// a match -- phase III -- stash the object's center position for later processing
			_lstThisCenter = getPosASL _x;

			// and stash that center in the list of all applicable centers
			_lstAllCenters set [ ( count _lstAllCenters) , +_lstThisCenter ];

		};
	}; 

} forEach _lstTemp;


// check to see if the above loop did anything
if ( _bRetVal ) then {

	// stash the data in the temporary setup structure -- the handles are pointers, the same everywhere... but the array of them is local
	_lstSetupTemp set [ 3 , +_lstAllObjects ];

	// now find the opening direction
	_lstTempVec = [ 0 , 0 ];
	_lstTempVec = [ ( _lstSetupTemp select 2 ) ] call fnc_findOpenDirection;

	// and put that into the status record
	_lstSetupTemp set [ 5 , ( _lstTempVec select 0 ) ];
	_lstSetupTemp set [ 6 , ( _lstTempVec select 1 ) ];

	// stash the object center locations BEFORE any moving -- and make a COPY into the next list, too, that will ultimately hold the OPEN ctrs
	_lstSetupTemp set [ 7 , ( +_lstAllCenters ) ];
	_lstSetupTemp set [ 8 , ( +_lstAllCenters ) ];

	// now find the overall moving width of the door based on the list of objects and the direction of motion

	// init a var
	_lstTempCoords = [ 0 , 0 , 0 ];

	// find the location of the first object in this list -- the home or master object whose direction and position are key to door motion
	_lstTempCoords = getPos ( _lstSetupTemp select 2 );

	// init a var
	_lstTempExtents = [ 0 , 0 ];

	// find the minima and maxima along the key door's direction of motion of all other doors in the list
	_lstTempExtents = [ ( _lstTempCoords select 0 ) , 
				    ( _lstTempCoords select 1 ) , 
				    ( _lstTempVec select 0 ) , 
				    ( _lstTempVec select 1 ) , 
			          _lstAllCenters ] call fnc_findMinMaxProjectedOntoFrameXAxis;

	// stash that value
	_lstSetupTemp set [ 4 , ( gblfMetalPlateWidth + abs ( ( _lstTempExtents select 0 ) - ( _lstTempExtents select 1 ) ) ) ];


	// and finally stash that structure into the array of all structures, previously setup ( if the structure is bad, the first element will still be false )
	gblLstDoorSetupData set [ _iGroupID , +_lstSetupTemp ];

	// initialize an index used to access the list of centers
	_iCtrIdx = 0;
	
	// now we also need to go through and set up deleted and killed event handlers on ALL objects in this door group....
	// while we're doing this, we're also going to copy the initial CLOSED locations into the objects' variable spaces on all clients, so that that info can be used for setup while open on other clients....
	{
		// add an event handler to the object that handles what happens when the object is deleted
		_iEHIndex = _x addEventHandler [ "Deleted", { [ _x ] execVM "HDAS_Client\OnDoorDelete.sqf"; } ];

		// and stash that index in the object's local variable space
		_x setVariable [ "DeletedEHIndex" , _iEHIndex , true ];
		
		// add an event handler to the object that handles what happens when the object is killed (destroyed)
		_iEHIndex = _x addEventHandler [ "killed", { [ _x ] execVM "HDAS_Client\OnDoorDelete.sqf"; } ];

		// and stash that index in the object's local variable space
		_x setVariable [ "KilledEHIndex" , _iEHIndex , true ];

		
		// set the center location into the object's variable space
		_x setVariable [ "OriginalCenter" , ( _lstAllCenters select _iCtrIdx ) , true ];

		// while we're at it, put the distance needing to be moved into EVERY object, too. Simplifies things so we don't have to look very hard to find it
		_x setVariable [ "DistanceToMove" , ( _lstSetupTemp  select 4 ) , true ];

		// increment the index
		_iCtrIdx = _iCtrIdx + 1;
		
	} forEach _lstAllObjects;

	// and since we're here, let's move ownership of all involved doors to this client...declare the public variable
	PVDZEP_MakeClientGroupOwner = [ player , _lstAllObjects ];

	// and publish the public server variable
	publicVariableServer "PVDZEP_MakeClientGroupOwner";
};


// done -- we fell through if the return value is a negative

// final return does NOT have a semicolon
_bRetVal
