//
// this routine sets up a hangar door the first time it's used in the game on one client, given that the doors are ALREADY open, having been opened by another client
//
// it builds the list of participating door objects, the direction in which it opens, a flag indicating whether or not it's set up, and the total distance it has to move
//
// usage after compilation
//
// _bRetVal = [ "classIDtext" , _intGroupID , _intKey ] call fnc_setupDoorOpsFromTypeGroupKeyWhileOpen;
//

private [ "_bRetVal" , "_lstAllObjects" , "_lstAllCentersOpen" , "_strType" , "_iGroupID" , "_iKeyID" , "_lstTemp" , "_lstDoorData" , "_iThisID" , "_iThisKey" , 
	"_iThisIdx" , "_objectID" , "_objectUID" , "_iTestValue" , "_lstSetupTemp" , "_lstTempVec" , "_iEHIndex" ,	"_lstAllCenterClosed" , "_fTempDist" ];


// init the list used to stash handles to all return values
_lstAllObjects = [];

// init the list of all object centers for processing
_lstAllCentersOpen = [];
_lstAllCentersClosed = [];
_lstThisCenter = [];

// init the return value
_bRetVal = false;

// get the arguments
_strType = _this select 0;
_iGroupID = _this select 1;
_iKeyID = _this select 2;

// make a temporary list -- this call COPIES information into a pointer-referenced array
_lstTemp = position player nearObjects [ _strType , gblfDoorSegmentSearchRange ];

// initialize a very large value
_iThisIdx = 1e38;

// initialize a status record as a COPY of the gbl default status record
_lstSetupTemp = +gblListDoorStatus;

// throw an error message if the init doesn't work!
if ( ( count _lstSetupTemp ) < 8 ) then {

	titleText [ "UH OH! The unary array copy operator doesn't work as expected!!!!" , "PLAIN DOWN", 3 ];
	sleep 20;
};

// now for each the elements of the temp list that match the specified group ID, figure out if this is an EARLIER db entry...
{
	// get the list of data from the object -- this call COPIES data from the variable space of the object into the array
	_lstDoorData = _x getVariable [ "VectorAndID" , [] ];
	
	// now check to see if that's defined
	if ( ( count _lstDoorData ) > 3 ) then {

		// there's at least 4 data points in there -- must be a door segment -- get the key and the door group ID
		_iThisKey = _lstDoorData select 2;
		_iThisID = _lstDoorData select 3;

		// check to see if the group IDs match:
		if ( ( _iGroupID == _iThisID ) && ( _iKeyID == _iThisKey ) )  then {

			// a match -- set the return flag to true
			_bRetVal = true;

			// a match -- there's going to be valid setup information for this setup record
			_lstSetupTemp set [ 0 , true ];
			_lstSetupTemp set [ 1 , "open" ];

			// a match -- phase I -- this object has the right type and group ID and keyset -- put this one into the persistent group
			_lstAllObjects set [ ( count _lstAllObjects ) , _x ];


			// a match -- phase II -- now get the data base index values from this object
			_objectID = _x getVariable [ "ObjectID" , "0" ];
			_objectUID = _x getVariable [ "ObjectUID" , "0" ];

			// if the object is NEW, then the primary key won't be available within the game yet -- all we have is the generated UID
			if ( _objectID == "0" ) then {
	
				// a new object -- compare the UID instead of the primary index ID -- and remember the object IDs come in as STRINGS!
				_iTestValue = parseNumber _objectUID;

			} else {

				// an object already in the db with a valid primary key retrieved into object variable space during object stream-in
				_iTestValue = parseNumber _objectID;
			};

			// now test the value
			if ( _iTestValue < _iThisIdx ) then {
				
				// found a new, earlier object ( or the first object that matches criteria )
				// save he new test index
				_iThisIdx = _iTestValue;

				// and stash the object handle in the outgoing variable
				_lstSetupTemp set [ 2 , _x ];
			};


			// a match -- phase III -- stash the object's center position NOW, open, and original center position, closed
			_lstThisCenter = getPosASL _x;

			// and stash that center in the list of all applicable centers, now/open
			_lstAllCentersOpen set [ ( count _lstAllCentersOpen ) , +_lstThisCenter ];

			// get the original center position from the object's persistent, pan-client variable space ( it's open, so the value WILL have been stored... )
			_lstThisCenter = _x getVariable [ "OriginalCenter" , [] ];

			// and stash THAT center in the list of all applicable centers, original/closed
			_lstAllCentersClosed set [ ( count _lstAllCentersClosed ) , +_lstThisCenter ];
		};
	}; 

} forEach _lstTemp;


// check to see if the above loop did anything
if ( _bRetVal ) then {

	// stash the data in the temporary setup structure
	_lstSetupTemp set [ 3 , +_lstAllObjects ];

	// now find the opening direction
	_lstTempVec = [ 0 , 0 ];
	_lstTempVec = [ ( _lstSetupTemp select 2 ) ] call fnc_findOpenDirection;

	// and put that into the status record
	_lstSetupTemp set [ 5 , ( _lstTempVec select 0 ) ];
	_lstSetupTemp set [ 6 , ( _lstTempVec select 1 ) ];

	// stash the object center locations BEFORE any moving -- and make a COPY into the next list, too, that will ultimately hold the OPEN ctrs
	_lstSetupTemp set [ 7 , ( +_lstAllCentersOpen) ];
	_lstSetupTemp set [ 8 , ( +_lstAllCentersClosed ) ];


	// THIS IS THE LOCATION OF THE COMPILE ERROR I COULDN'T FIND FOR A WHILE I THINK 

	// now recover the overall moving width of the door from the primary door in the door group
	_fTempDist = ( _lstSetupTemp select 2 ) getVariable [ "DistanceToMove" , 0 ];


	// stash that value
	_lstSetupTemp set [ 4 , _fTempDist ];

	// and finally stash that structure into the array of all structures, previously setup ( if the structure is bad, the first element will still be false )
	gblLstDoorSetupData set [ _iGroupID , +_lstSetupTemp ];
	
	// now we also need to go through and set up deleted and killed event handlers on ALL objects in this door group....
	{
		// add an event handler to the object that handles what happens when the object is deleted
		_iEHIndex = _x addEventHandler [ "Deleted", { [ _x ] execVM "HDAS_Client\OnDoorDelete.sqf"; } ];

		// and stash that index in the object's local variable space
		_x setVariable [ "DeletedEHIndex" , _iEHIndex , true ];
		
		// add an event handler to the object that handles what happens when the object is killed (destroyed)
		_iEHIndex = _x addEventHandler [ "killed", { [ _x ] execVM "HDAS_Client\OnDoorDelete.sqf"; } ];

		// and stash that index in the object's local variable space
		_x setVariable [ "KilledEHIndex" , _iEHIndex , true ];
		
	} forEach _lstAllObjects;

	// and since we're here, let's move ownership of all involved doors to this client...declare the public variable
	PVDZEP_MakeClientGroupOwner = [ player , _lstAllObjects ];

	// and publish the public server variable
	publicVariableServer "PVDZEP_MakeClientGroupOwner";
};


// done -- we fell through if the return value is a negative

// final return does NOT have a semicolon
_bRetVal
