private [ "_objVehicle" , "_hitpoints" , "_type" , "_selection" ];

// get the vehicle passed to the script
_objVehicle = _this select 3;

// get an array of hitpoints for the vehicle
_hitpoints = _objVehicle call vehicle_getHitpoints;

// get the type of vehicle
_type = typeOf _objVehicle;

// loop through all hitpoint items for each vehicle
{
	_selection = getText( configFile >> "cfgVehicles" >> _type >> "HitPoints" >> _x >> "name" );
	[ _objVehicle , _selection , 0 , true ] call fnc_veh_handleRepair;

} forEach _hitpoints;        // end of loop in list of hitpoint items


// reset damage for the vehicle
_objVehicle setDamage 0;


titleText [ "Vehicle repaired.", "PLAIN DOWN", 3 ];
titleFadeOut 3;
