// Script based on various versions from Krixes 
// Infection chance and comments added by Player2
// further changes and integration 8/7


// force scope of variables to be file-wide
private ["_isLoopCompleted"];


// if the in-process self-bloodbagging flag has never been set, make it false
if ( isNil "globalRebloodingNowFlag" ) then { 
    globalRebloodingNowFlag = false; 
};

// if we're NOT self-bloodbagging, then attempt to self-bloodbag now
if ( !globalRebloodingNowFlag ) then {

    // set the flag
    globalRebloodingNowFlag = true;

    // remove the action from users scroll menu
    player removeAction s_player_selfBloodbag;

    // reset the menu item index
    s_player_selfBloodbag = -1;

    // remove the used bloodbag from inventory
    if ( "ItemBloodbag" in magazines player ) then {

        // remove the basic old style bag if we have one
        player removeMagazine "ItemBloodbag";

    } else {

        // only way we can get into this code is if we have an old style bag OR a newfangled O-neg bag
        // only way we can hit this scope right here is if we DON'T have an oldfangled bag
        // so remove a newfangled o-neg bag
        player removeMagazine "wholeBloodBagONEG";
    };

    // display a message
    titleText ["You're administering a blood bag to yourself. Wait....", "PLAIN DOWN", 3];

    // play bloodbag animation
    player playActionNow "Medic";

    // wait 5 seconds for the animation to run
    sleep 5;

    // do this loop 50 times, or occupy 25 seconds....
    for "_iloop" from 1 to 50 do {

        // set a loop completion flag
        _isLoopCompleted = false;

        // see if we started moving and bag out if we have
        if ( speed player > 1 ) exitWith { };
   
        // pause a moment
        sleep 0.5;

        // set the loop completion flag
        _isLoopCompleted = true;

    };

    if ( _isLoopCompleted ) then {

        // set player blood to the maximum allowed -- client side
        r_player_blood = r_player_bloodTotal;

        // set player blood back up to full again -- server side
        player setVariable ["USEC_BloodQty", r_player_bloodTotal, true];

        // resetting client side low blood flag
        r_player_lowblood = false;

        // slowly fade audio volume back to full
        10 fadeSound 1;

        // disable post processing blur effect
        "dynamicBlur" ppEffectAdjust [0];
        "dynamicBlur" ppEffectCommit 5;
        "colorCorrections" ppEffectAdjust [1, 1, 0, [1, 1, 1, 0.0], [1, 1, 1, 1],  [1, 1, 1, 1]];
        "colorCorrections" ppEffectCommit 5;

        // display a message
        titleText ["You're COMPLETED administering a blood bag to yourself.", "PLAIN DOWN", 3];

    } else {

        titleText ["Self-administering bloodbag INTERRUPTED!", "PLAIN DOWN", 3];

    };

    if ( random 100 < gblChanceBloodInfected ) then {

        // client side notification that the player is infected
        r_player_infected = true;

        // server side notification that the player is infected
        player setVariable ["USEC_infected", true, true];

    };

    // clear the refilling flag
    globalRebloodingNowFlag = false;

};
