// first version 8/4 based on last III version st code
// 8/5 added difficulty display
// 8/5 added restart warnings
// 8/29 -- move to 4 hour delta restart timing using publicVariable from Server
// 12/6 -- attempt to add flexible restart notification system
// 1/8/17 -- changes to make function with 1.0.6
// 1/14 resinstalled 6 hour and 45 min timers


private [ "_bWarning45min" , "_bWarning30min" , "_bWarning15min" , "_bWarning10min" , "_bWarning5min" , "_bWarning3min" , "_bWarning2min" , "_bWarning1min" , "_iDiffPct" ,
    "_fdServerTimeSecs" , "_fdServerTimeHrs" , "_iHours" , "_iMinutes" , "_strTime" ];

// always do this
if ( true ) then {

	// initialize the flags for the restart warning notice system
	_bWarning45min = false;
	_bWarning30min = false;
	_bWarning20min = false;
	_bWarning15min = false;
	_bWarning10min = false;
	_bWarning5min = false;
	_bWarning3min = false;
	_bWarning2min = false;
	_bWarning1min = false;


 	diag_log "[INIT] GO FOR PLAYER MGT LOOP";


    // loop forever
    while { true } do { 

        // update the global zombie difficulty factor
        GlobalZedDiffAdj = [] call fnc_findInlandDiffFactor;

        // stat monitor

        _iZedKills = player getVariable[ "zombieKills" , 0 ];
        _iPlayerKills = player getVariable[ "humanKills" , 0 ];
        _iBanditKills = player getVariable[ "banditKills" , 0 ];
        _iHumanity = player getVariable[ "humanity" , 0 ];
        _iHeadshots = player getVariable[ "headShots" , 0 ];


        // calculate the difficulty PERCENTAGE
        _iDiffPct = floor ( GlobalZedDiffAdj * 100 );

        // get the total elapsed serverTime
        _fdServerTimeSecs = serverTime;

        // calculate the time variable from the broadcast value in hours
        _fdServerTimeHrs = _fdServerTimeSecs / 3600.0;

        // calculate the display values
        _iHours = floor _fdServerTimeHrs;
        _iMinutes = floor ( ( _fdServerTimeHrs - _iHours ) * 60 );
        _strTime = format ["%1hr%2min" , _iHours , _iMinutes ];


	// print the debug monitor
        hintSilent parseText format ["
            <t size='1'font='Bitstream'align='left'>Blood:</t><t size='1' font='Bitstream'align='right'>%1</t><br/>
            <t size='1'font='Bitstream'align='left'>Humanity:</t><t size='1'font='Bitstream'align='right'>%2</t><br/>
            <t size='1'font='Bitstream'align='left'>Players Killed:</t><t size='1'font='Bitstream'align='right'>%3</t><br/>
            <t size='1'font='Bitstream'align='left'>Bandits Killed:</t><t size='1'font='Bitstream'align='right'>%4</t><br/>
            <t size='1'font='Bitstream'align='left'>Zombies Killed:</t><t size='1'font='Bitstream'align='right'>%5</t><br/>
            <t size='1'font='Bitstream'align='left'>Headshots:</t><t size='1'font='Bitstream'align='right'>%6</t><br/>
            <t size='1'font='Bitstream'align='left'>Difficulty Pct:</t><t size='1'font='Bitstream'align='right'>%7</t><br/>
            <t size='1'font='Bitstream'align='left'>Server Up:</t><t size='1'font='Bitstream'align='right'>%8</t>
            " , r_player_blood , ( round _iHumanity ) , _iPlayerKills , _iBanditKills , _iZedKills , _iHeadshots , _iDiffPct , _strTime ];


	// the ONLY time we check for time warnings is if we're at least ten minutes into the sixth hour
	if ( _fdServerTimeHrs > gblWarningTime50min ) then {

		// if we have NOT prev displayed 45 min warning, AND server time is greater than 15 minutes into hour 6, then display the 45 minute warning!
		if ( ( !_bWarning45min ) && ( _fdServerTimeHrs > gblWarningTime45min ) )  then {

			// the 45 minute warning -- set the flag
			_bWarning45min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 45 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 30 min warning, AND server time is greater than 30 minutes into hour 6, then display the 30 minute warning!
		if ( ( !_bWarning30min ) && ( _fdServerTimeHrs > gblWarningTime30min ) )  then {

			// the 30 minute warning -- set the flag
			_bWarning30min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 30 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 20 min warning, AND server time is greater than 40 minutes into hour 6, then display the 20 minute warning!
		if ( ( !_bWarning20min ) && ( _fdServerTimeHrs > gblWarningTime20min ) )  then {

			// the 20 minute warning -- set the flag
			_bWarning20min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 20 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 15 min warning, AND server time is greater than 45 minutes into hour 6, then display the 15 minute warning!
		if ( ( !_bWarning15min ) && ( _fdServerTimeHrs > gblWarningTime15min ) )  then {

			// the 15 minute warning -- set the flag
			_bWarning15min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 15 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 10 min warning, AND server time is greater than 50 minutes into hour 6, then display the 10 minute warning!
		if ( ( !_bWarning10min ) && ( _fdServerTimeHrs > gblWarningTime10min ) )  then {

			// the 10 minute warning -- set the flag
			_bWarning10min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 10 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 5 min warning, AND server time is greater than 55 minutes into hour 6, then display the 5 minute warning!
		if ( ( !_bWarning5min ) && ( _fdServerTimeHrs > gblWarningTime5min ) )  then {

			// the 5 minute warning -- set the flag
			_bWarning5min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 5 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 3 min warning, AND server time is greater than 57 minutes into hour 6, then display the 3 minute warning!
		if ( ( !_bWarning3min ) && ( _fdServerTimeHrs > gblWarningTime3min ) )  then {

			// the 3 minute warning -- set the flag
			_bWarning3min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 3 MINUTES.", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 2 min warning, AND server time is greater than 58 minutes into hour 6, then display the 2 minute warning!
		if ( ( !_bWarning2min ) && ( _fdServerTimeHrs > gblWarningTime2min ) )  then {

			// the 2 minute warning -- set the flag
			_bWarning2min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 2 MINUTES!", "PLAIN DOWN", 3];
		};

		// if we have NOT prev displayed 1 min warning, AND server time is greater than 59 minutes into hour 6, then display the 1 minute warning!
		if ( ( !_bWarning1min ) && ( _fdServerTimeHrs > gblWarningTime1min ) )  then {

			// the 1 minute warning -- set the flag
			_bWarning1min = true;

			// the message
			titleText ["SERVER WILL RESTART IN 1 MINUTE!", "PLAIN DOWN", 3];
		};

        };

        // main loop interval
        sleep 1;

    };

};
