
private [ "_PosPlayer" , "_CoordX" , "_CoordY" , "_xvalue" , "_yvalue" , "_retval" ];


// find the player's position
_PosPlayer = getPos player;


// get the individual coordinates
_CoordX = _PosPlayer select 0;
_CoordY = _PosPlayer select 1;


// check to see if the player is in the minimum adjustment zone ACROSS ...
if ( _CoordX < DiffFactMinZoneX ) then {

    	// set the return value to the minimum constant value
    	_xvalue = DiffFactRetvalMin;

} else {

    	// check to see if the player is in the maximum adjustment zone....
    	if ( _CoordX > DiffFactMaxZoneX ) then {

        	// set the return value to the maximum constant value
        	_xvalue = DiffFactRetvalMax;

    	} else {

        	// we're in-between, and need to calculate the adjustment
        	_xvalue = DiffFactRetvalMin + ( _CoordX - DiffFactMinZoneX )* DiffFactLineSlopeX;

    };
};


// check to see if the player is in the minimum adjustment zone UP AND DOWN ...
if ( _CoordY > DiffFactMinZoneY ) then {

    // set the return value to the minimum constant value
    _yvalue = DiffFactRetvalMin;

} else {

	// check to see if the player is in the maximum adjustment zone ...

	if ( _CoordY < DiffFactMaxZoneY ) then {

		// set the return value to the maximum constant value
		_yvalue = DiffFactRetvalMax;

	} else {

		// we're in-between, and need to calculate the adjustment
		_yvalue = DiffFactRetvalMax - ( _CoordY - DiffFactMaxZoneY )* DiffFactLineSlopeY;

    };
};


// find the combined factor
_retval = _xvalue * _yvalue;


// the last line of a function is the return value -- no semicolon!
_retval