
private [ "_objVehicle", "_bRetValue", "_objTestVehicle", "_bInVehicle", "_bOutVehicle", "_fHeading", "_posPosBefore" ];

// get the argument -- the vehicle to be localized
_objVehicle = _this select 0;

// initialize the return value
_bRetValue = false;

// get the player starting position and heading
_fHeading = getDir player;
_posPosBefore = getPos player;

// try to install the player into the designated vehicle
player action [ "getInDriver" , _objVehicle ];
sleep 4;

// now see if the player is IN the correct vehicle!
_objTestVehicle = vehicle player;
_bInVehicle = ( ( _objTestVehicle != player ) && ( _objTestVehicle == _objVehicle ) );

if ( _bInVehicle ) then {

    // so far, so good - now try to get OUT of the vehicle
    player action [ "eject" , _objVehicle ];
    sleep 4;

    // now make sure we're NOT in any vehicle
    _objTestVehicle = vehicle player;
    _bOutVehicle = ( _objTestVehicle == player );

    if ( _bOutVehicle ) then {

        // excellent! we got in and out again -- so we're done!
        // we need to restore the "pre-climb-in" position and heading

//_strTemp = format ["New _fHeading is %1", _fHeading ];
//titleText [_strTemp, "PLAIN DOWN", 3];
//sleep 2;

        player setPos _posPosBefore;
        player setDir _fHeading;

        // set the success flag
        _bRetValue = true;

    } else {

        // a failure! we're done here
        _bRetValue = false;
    };

} else {
    
    // a failure! we're done here
    _bRetValue = false;
    
};

//_strTemp = format ["_vehicle is %1", _vehicle];
//titleText [_strTemp, "PLAIN DOWN", 3];
//sleep 1.0;

// the last line of a function is the return value -- no semicolon!
_bRetValue