// global hunger/thirst reduction

globalHTR = 5;

// ghost town variables

globalGhostTownSoundIdx=0;
globalGhostTownSoundsUsed=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];

// new blood infection chances
gblChanceBloodInfected = 7;

// added variables for difficulty factor adjustment here
// west of minzone, nominal difficulty -- east of maxzone, max difficulty
DiffFactMinZoneX = 6000;
DiffFactMaxZoneX = 18000;

DiffFactMinZoneY = 12570;
DiffFactMaxZoneY = 2000;

// the min and max adjustments
DiffFactRetvalMin = 1.0;
DiffFactRetvalMax = 2.0;

// The difficulty adjustment constants
DiffFactLineSlopeX = ( DiffFactRetvalMax - DiffFactRetvalMin ) / ( DiffFactMaxZoneX - DiffFactMinZoneX );
DiffFactLineSlopeY = ( DiffFactRetvalMax - DiffFactRetvalMin ) / ( DiffFactMinZoneY - DiffFactMaxZoneY );

// initialize the global zombie difficulty adjustment
GlobalZedDiffAdj = 1.0;


// variables for admin priv TP ops

gblListAdminTPRemoveActions = [];

gblbAdminTPControl = 0;



// variables for salvage operations

gblObjLastSalvageCursorTarget = objNull;

gblListSalvagePlayerRemoveActions = [];

gblListSalvageOptionFlags = [ 0 , 0 , 0 , 0 ];

gblbPlayerSalvageControl = 0;



// variables for delta time restart warning system

// 50 min warning window -- 10 mintes into the sixth hour
gblWarningTime50min = 5.1667;
// 45 min warning -- 15 minutes into the sixth hour
gblWarningTime45min = 5.25;
// 30 min warning -- 30 minutes into the sixth hour
gblWarningTime30min = 5.5;
// 20 min warning -- 40 minutes into the sixth hour
gblWarningTime20min = 5.6667;
// 15 min warning -- 45 minutes into the sixth hour
gblWarningTime15min = 5.75;
// 10 min warning -- 50 minutes into the sixth hour
gblWarningTime10min = 5.8333;
// 5 min warning -- 55 minutes into the sixth hour
gblWarningTime5min = 5.9166;
// 3 min warning -- 57 minutes into the sixth hour
gblWarningTime3min = 5.95;
// 2 min warning -- 58 minutes into the sixth hour
gblWarningTime2min = 5.9666;
// 1 min warning -- 59 minutes into the sixth hour
gblWarningTime1min = 5.9833;


// admin 

gblfAdminOptions1Control = 0;
gblObjLastAdmin1CursorTarget = objNull;
gblAdminOptions1RemoveActions = [];

gblfAdminOptions2Control = 0;
gblObjLastAdmin2CursorTarget = objNull;
gblAdminOptions2RemoveActions = [];

gblfAdminOptions3Control = 0;
gblObjLastAdmin3CursorTarget = objNull;
gblAdminOptions3RemoveActions = [];



// list of players with admin privileges
gblAdminGUIDs = [ "76561198032532024" , "76561197971367234" , "76561197975081165" ];


// list of players with privileges
gblPrivilegedGUIDs = [ "76561198032532024" , "76561197971367234" , "76561197975081165" ];


// list of players with VERY privileges
gblVeryPrivilegedGUIDs = [ "76561198032532024" , "76561197975081165" , "76561197971367234" ];



// variables for transport system


// transports that can carry any standard large road vehicle
gblTransportTypesH2 = [ "C130J" , "C130J_US_EP1_DZ" ];

// transports that can carry any medium road vehicle
gblTransportTypesH1 = [ "CH53_DZE" , "CH53_DZ" , "CH_47F_EP1_DZE" , "CH_47F_EP1_DZ" , "CH_47F_BAF" , "CH_47F_EP1" , "BAF_Merlin_DZE" , "BAF_Merlin_DZ" , "BAF_Merlin_HC3_D" ];

// transports that can carry any small vehicle 
gblTransportTypesO = [ "Mi17_Civilian" , "Mi17_Civilian_DZ" , "Mi17_DZE" , "Mi17_CDF" , "Mi17_DZ" , "Mi17_Ins" , "Mi17_medevac_CDF" , "Mi17_medevac_INS" , "Mi17_medevac_RU" , "Mi17_rockets_RU" , "Mi17_TK_EP1" , "Mi17_UN_CDF_EP1" ];

// transports that can carry bikes, motorcycles, and quads
gblTransportTypesA = [ "datsun1_civil_1_open" , "datsun1_civil_3_open" , "hilux1_civil_1_open" , "hilux1_civil_3_open" , "hilux1_civil_3_open_EP1" , "HMMWV_Ambulance" , "HMMWV_Ambulance_CZ_DES_EP1 , HMMWV_M1035_DES_EP1" , "Kamaz" , "Kamaz_DZE", "LandRover_CZ_EP1" , "LandRover_TK_CIV_EP1" , "MTVR_DES_EP1" , "MV22_DZ" , "Ural_CDF" , "Ural_TK_CIV_EP1" , "Ural_UN_EP1" , "V3S_Open_TK_CIV_EP1" , "V3S_Open_TK_EP1" , "AAV" , "BMP3" , "BTR40_MG_TK_GUE_EP1" , "BTR40_MG_TK_INS_EP1" , "BTR40_TK_GUE_EP1" , "BTR40_TK_INS_EP1" , "BTR90" , "BTR90_HQ" , "HMMWV_Ambulance_DES_EP1 " , "HMMWV_Terminal_EP1" , "KamazOpen" , "KamazReammo" , "KamazRepair" , "LAV25" , "LAV25_HQ" , "M1126_ICV_M2_EP1" , "M1126_ICV_mk19_EP1" , "M1128_MGS_EP1" , "M1129_MC_EP1" , "M113Ambul_TK_EP1" , "M113Ambul_TK_EP1_DZ" , "M113Ambul_UN_EP1" , "M113Ambul_UN_EP1_DZ" , "M113_TK_EP1"  , "M113_UN_EP1" , "M1130_CV_EP1" , "M1133_MEV_EP1" , "M1135_ATGMV_EP1" , "M2A2_EP1" , "M2A3_EP1" , "M6_EP1" , "MAZ_543_SCUD_TK_EP1" , "MTVR" , "MtvrReammo" , "MtvrReammo_DES_EP1" , "MtvrRepair" , "MtvrRepair_DES_EP1" , "MtvrSalvage_DES_EP1" , "MtvrSupply_DES_EP1" , "UralCivil" , "UralCivil2" , "Ural_INS" , "UralOpen_CDF" , "UralOpen_INS" , "UralReammo_CDF" , "UralReammo_INS" , "UralReammo_TK_EP1" , "UralRepair_CDF" , "UralRepair_INS" , "UralRepair_TK_EP1" , "UralSalvage_TK_EP1" , "UralSupply_TK_EP1" , "V3S_Civ" , "V3S_Gue" , "V3S_Reammo_TK_GUE_EP1" , "V3S_Repair_TK_GUE_EP1" , "V3S_Salvage_TK_GUE_EP1" , "V3S_Supply_TK_GUE_EP1" , "V3S_TK_EP1" , "V3S_TK_GUE_EP1" , "V3S_TK_EP1_DZE" , "V3S_RA_TK_GUE_EP1_DZE"  , "UralCivil_DZE" , "UralCivil2_DZE" , "KamazOpen_DZE" , "WarfareReammoTruck_CDF" , "WarfareReammoTruck_Gue" , "WarfareReammoTruck_INS" , "WarfareReammoTruck_RU" , "WarfareReammoTruck_USMC" , "WarfareRepairTruck_Gue" , "WarfareSalvageTruck_CDF" , "WarfareSalvageTruck_Gue" , "WarfareSalvageTruck_INS" , "WarfareSalvageTruck_RU" , "WarfareSalvageTruck_USMC" , "WarfareSupplyTruck_CDF" , "WarfareSupplyTruck_Gue" , "WarfareSupplyTruck_INS" , "WarfareSupplyTruck_RU" , "WarfareSupplyTruck_USMC" , "Mi171Sh_CZ_EP1" , "Mi171Sh_rockets_CZ_EP1" , "Mi24_D" , "Mi24_D_TK_EP1" , "Mi24_P" , "Mi24_V" , "MH60S" , "MV22" , "UH60M_EP1"  , "UH60M_EP1_DZ" , "UH60M_MEV_EP1" ];

// transports that can carry only motorcycles and bikes
gblTransportTypesB = [ "Fishing_Boat" , "HMMWV_M998A2_SOV_DES_EP1_DZE" , "HMMWV_M998A2_SOV_DES_EP1_DZ" , "LandRover_MG_TK_EP1_DZE" , "LandRover_MG_TK_EP1_DZ" , "LandRover_Special_CZ_EP1_DZE" , "LandRover_Special_CZ_EP1_DZ" , "Offroad_DSHKM_Gue_DZE" , "Offroad_DSHKM_Gue_DZ" , "UH1H_DZE" , "UH1H_DZ" , "UH1Y_DZE" , "UH1Y_DZ" , "UH60M_EP1_DZE" , "UH60M_EP1_DZ" , "BMP2_Ambul_CDF" , "BMP2_Ambul_INS" , "BMP2_CDF" , "BMP2_HQ_CDF" , "BMP2_HQ_INS" , "BMP2_HQ_TK_EP1" , "BMP2_INS" , "BMP2_GUE" , "BMP2_TK_EP1" , "BMP2_UN_EP1" , "HMMWV_M998_crows_M2_DES_EP1" , "HMMWV_M998_crows_MK19_DES_EP1" , "HMMWV_M998A2_SOV_DES_EP1" , "HMMWV_M998A2_SOV_DES_EP1_DZ" , "UH1H_DZ" , "UH1H_TK_EP1" , "UH1H_TK_GUE_EP1" , "UH1Y_DZ" , "GAZ_Vodnik" , "GAZ_Vodnik_DZ" , "GAZ_Vodnik_DZE" , "GAZ_Vodnik_DZ_LM" , "GAZ_Vodnik_DZ_VLM" , "GAZ_Vodnik_HMG" , "GAZ_Vodnik_MedEvac" ];

// transports that can carry bikes only
gblTransportTypesC = [ "An2_1_TK_CIV_EP1" , "An2_2_TK_CIV_EP1" , "An2_TK_EP1" , "AN2_DZ" , "ArmoredSUV_PMC" , "ArmoredSUV_PMC_DZ" , "ArmoredSUV_PMC_DZE" , "car_hatchback" , "datsun1_civil_2_covered" , "hilux1_civil_2_covered" , "HMMWV_DES_EP1" , "HMMWV_DZ" , "HMMWV_M1151_M2_CZ_DES_EP1_DZE" , "HMMWV_M1151_M2_CZ_DES_EP1_DZ" , "Ikarus" , "Ikarus_TK_CIV_EP1" , "KamazRefuel_DZ" , "MH6J_DZ" , "MtvrRefuel_DES_EP1_DZ" , "PBX" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "Pickup_PK_TK_GUE_EP1_DZ" , "RHIB" , "S1203_ambulance_EP1" , "S1203_TK_CIV_EP1" , "Smallboat_1" , "Smallboat_2" , "SUV_Blue" , "SUV_Camo" , "SUV_Charcoal" , "SUV_Green" , "SUV_Orange" , "SUV_Pink" , "SUV_Red" , "SUV_Silver" , "SUV_TK_CIV_EP1" , "SUV_White" , "SUV_Yellow" , "tractor" , "UAZ_CDF" , "UAZ_INS" , "UAZ_MG_TK_EP1_DZE" , "UAZ_MG_TK_EP1_DZ" , "UAZ_RU" , "UAZ_Unarmed_TK_CIV_EP1" , "UAZ_Unarmed_TK_EP1" , "UAZ_Unarmed_UN_EP1" , "UralRefuel_TK_EP1_DZ" , "V3S_Refuel_TK_GUE_EP1_DZ" , "Zodiac" , "2S6M_Tunguska" , "BAF_FV510_D" , "BAF_FV510_W" , "BAF_Jackal2_GMG_D" , "BAF_Jackal2_GMG_W" , "BAF_Jackal2_L2A1_D" , "BAF_Jackal2_L2A1_W" , "BRDM2_ATGM_CDF" , "BRDM2_ATGM_INS" , "BRDM2_ATGM_TK_EP1" , "BRDM2_ATGM_TK_GUE_EP1" , "BRDM2_CDF" , "BRDM2_Gue" , "BRDM2_HQ_Gue" , "BRDM2_HQ_TK_GUE_EP1" , "BRDM2_INS" , "BRDM2_TK_EP1" , "BRDM2_TK_GUE_EP1" , "BTR60_TK_EP1" , "GRAD_CDF" , "GRAD_INS" , "GRAD_RU" , "GRAD_TK_EP1" , "HMMWV_Armored" , "HMMWV_Avenger" , "HMMWV_Avenger_DES_EP1" , "HMMWV_M1151_M2_CZ_DES_EP1" , "HMMWV_M1151_M2_CZ_DES_EP1_DZ" , "HMMWV_M1151_M2_DES_EP1" , "HMMWV_M2" , "HMMWV_MK19" , "HMMWV_MK19_DES_EP1" , "HMMWV_TOW" , "HMMWV_TOW_DES_EP1" , "HMMWV" , "KamazRefuel" , "LandRover_MG_TK_EP1" , "LandRover_MG_TK_EP1_DZ" , "LandRover_MG_TK_INS_EP1" , "LandRover_Special_CZ_EP1" , "LandRover_Special_CZ_EP1_DZ" , "LandRover_SPG9_TK_EP1" , "LandRover_SPG9_TK_INS_EP1" , "M1A1" , "M1A1_US_DES_EP1" , "M1A2_TUSK_MG" , "M1A2_US_TUSK_MG_EP1" , "MLRS" , "MLRS_DES_EP1" , "MtvrRefuel" , "MtvrRefuel_DES_EP1_DZ" , "Offroad_DSHKM_Gue" , "Offroad_DSHKM_Gue_DZ" , "Offroad_DSHKM_Gue_DZE1" , "Offroad_DSHKM_Gue_DZE2" , "Offroad_DSHKM_Gue_DZE3" , "Offroad_DSHKM_Gue_DZE4" , "Offroad_DSHKM_INS" , "Offroad_DSHKM_TK_GUE_EP1" , "Offroad_SPG9_Gue" , "Offroad_SPG9_TK_GUE_EP1" , "Pickup_PK_GUE" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_INS" , "Pickup_PK_INS_DZ" , "Pickup_PK_INS_DZE" , "Pickup_PK_TK_GUE_EP1" , "RHIB" , "Pickup_PK_TK_GUE_EP1_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "Pickup_PK_TK_GUE_EP1_DZ" , "SUV_DZ" , "SUV_Orange" , "SUV_PMC" , "SUV_PMC_BAF" , "SUV_TK_EP1" , "SUV_UN_EP1" , "T34" , "T34_TK_EP1" , "T34_TK_GUE_EP1" , "T55_TK_EP1 , T55_TK_GUE_EP1" , "T72_CDF" , "T72_INS" , "T72_GUE" , "T72_RU" , "T72_TK_EP1" , "T90" , "TowingTractor" , "UAZ_AGS30_CDF" , "UAZ_AGS30_INS" , "UAZ_AGS30_RU" , "UAZ_AGS30_TK_EP1" , "UAZ_MG_CDF" , "UAZ_MG_INS" , "UAZ_MG_INS_DZ_LM" , "UAZ_MG_INS_DZ_VLM" , "UAZ_MG_CDF" , "UAZ_MG_CDF_DZ_LM" , "UAZ_MG_CDF_DZ_VLM" , "UAZ_MG_TK_EP1" , "UAZ_MG_TK_EP1_DZ" , "UAZ_SPG9_INS" , "UralRefuel_CDF" , "UralRefuel_INS" , "UralRefuel_TK_EP1" , "Ural_ZU23_CDF" , "Ural_ZU23_INS" , "Ural_ZU23_Gue" , "Ural_ZU23_TK_EP1" , "Ural_ZU23_TK_GUE_EP1" , "V3S_Refuel_TK_GUE_EP1" , "MtvrRefuel_DZ" , "ZSU_CDF" , "ZSU_INS" , "ZSU_TK_EP1" , "AW159_Lynx_BAF" , "Ka60_GL_PMC" , "Ka60_PMC" , "MH6J_EP1" , "pook_H13_medevac" , "pook_H13_medevac_CDF" , "pook_H13_medevac_TAK" , "pook_H13_medevac_INS , pook_H13_medevac_UNO" , "pook_H13_medevac_PMC" , "pook_H13_medevac_GUE" , "pook_H13_medevac_CIV" , "pook_H13_medevac_CIV_RU" ];



// transportables that load onto transports types H2 -- heavy trucks and smaller
gblTransportableTypesH2 = [ "ArmoredSUV_PMC" , "ArmoredSUV_PMC_DZ" , "ArmoredSUV_PMC_DZE" , "ArmoredSUV_PMC_DZ" , "GAZ_Vodnik_DZE" , "GAZ_Vodnik_DZ" , "GAZ_Vodnik_MedEvac" , "HMMWV_DES_EP1" , "HMMWV_DZ" , "HMMWV_M1151_M2_CZ_DES_EP1_DZE" , "HMMWV_M1151_M2_CZ_DES_EP1_DZ" , "KamazRefuel_DZ" , "MtvrRefuel_DES_EP1_DZ" , "SUV_Blue" , "SUV_Camo" , "SUV_Charcoal" , "SUV_Green" , "SUV_Orange" , "SUV_Pink" , "SUV_Red" , "SUV_Silver" , "SUV_TK_CIV_EP1" , "SUV_White" , "SUV_Yellow" , "tractor" , "UralRefuel_TK_EP1_DZ" , "V3S_Refuel_TK_GUE_EP1_DZ" , "HMMWV_M998A2_SOV_DES_EP1_DZE" , "HMMWV_M998A2_SOV_DES_EP1_DZ" , "HMMWV_Ambulance" , "HMMWV_Ambulance_CZ_DES_EP1" , "HMMWV_M1035_DES_EP1" , "Kamaz" , "MTVR_DES_EP1" , "Ural_CDF" , "Ural_TK_CIV_EP1" , "Ural_UN_EP1" , "V3S_Open_TK_CIV_EP1" , "V3S_Open_TK_EP1" , "GRAD_CDF" , "GRAD_INS" , "GRAD_RU" , "GRAD_TK_EP1" , "HMMWV_Ambulance_DES_EP1" , "HMMWV_Armored" , "HMMWV_Avenger" , "HMMWV_Avenger_DES_EP1" , "HMMWV_M1151_M2_CZ_DES_EP1" , "HMMWV_M1151_M2_CZ_DES_EP1_DZ" , "HMMWV_M1151_M2_DES_EP1" , "HMMWV_M2" , "HMMWV_M998_crows_M2_DES_EP1" , "HMMWV_M998_crows_MK19_DES_EP1" , "HMMWV_M998A2_SOV_DES_EP1" , "HMMWV_M998A2_SOV_DES_EP1_DZ" , "HMMWV_MK19" , "HMMWV_MK19_DES_EP1" , "HMMWV_Terminal_EP1" , "HMMWV_TOW" , "HMMWV_TOW_DES_EP1" , "HMMWV" , "KamazOpen" , "KamazReammo" , "KamazRefuel" , "KamazRepair" , "MTVR" , "MtvrReammo" , "MtvrReammo_DES_EP1" , "MtvrRefuel" , "MtvrRefuel_DES_EP1_DZ" , "MtvrRepair" , "MtvrRepair_DES_EP1" , "MtvrSalvage_DES_EP1" , "MtvrSupply_DES_EP1" , "SUV_DZ" , "SUV_Orange" , "SUV_PMC" , "SUV_PMC_BAF" , "SUV_TK_EP1" , "SUV_UN_EP1" , "UralCivil" , "UralCivil2" , "Ural_INS" , "UralOpen_CDF" , "UralOpen_INS" , "UralReammo_CDF" , "UralReammo_INS" , "UralReammo_TK_EP1" , "UralRefuel_CDF" , "UralRefuel_INS" , "UralRefuel_TK_EP1" , "UralRepair_CDF" , "UralRepair_INS" , "UralRepair_TK_EP1" , "UralSalvage_TK_EP1" , "UralSupply_TK_EP1" , "Ural_ZU23_CDF" , "Ural_ZU23_INS" , "Ural_ZU23_Gue" , "Ural_ZU23_TK_EP1" , "Ural_ZU23_TK_GUE_EP1" , "V3S_Civ" , "V3S_Gue" , "V3S_Reammo_TK_GUE_EP1" , "V3S_Refuel_TK_GUE_EP1" , "V3S_Repair_TK_GUE_EP1" , "V3S_Salvage_TK_GUE_EP1" , "V3S_Supply_TK_GUE_EP1" , "V3S_TK_EP1" , "V3S_TK_GUE_EP1" , "V3S_TK_EP1_DZE" , "V3S_RA_TK_GUE_EP1_DZE"  , "UralCivil_DZE" , "UralCivil2_DZE" , "KamazOpen_DZE" , "MtvrRefuel_DZ" , "WarfareReammoTruck_CDF" , "WarfareReammoTruck_Gue" , "WarfareReammoTruck_INS" , "WarfareReammoTruck_RU" , "WarfareReammoTruck_USMC" , "WarfareRepairTruck_Gue" , "WarfareSalvageTruck_CDF" , "WarfareSalvageTruck_Gue" , "WarfareSalvageTruck_INS" , "WarfareSalvageTruck_RU" , "WarfareSalvageTruck_USMC" , "WarfareSupplyTruck_CDF" , "WarfareSupplyTruck_Gue" , "WarfareSupplyTruck_INS" , "WarfareSupplyTruck_RU" , "WarfareSupplyTruck_USMC" , "BAF_Jackal2_GMG_D" , "BAF_Jackal2_GMG_W" , "BAF_Jackal2_L2A1_D" , "BAF_Jackal2_L2A1_W" ,
                           "hilux1_civil_2_covered" , "LandRover_MG_TK_EP1_DZE" , "LandRover_MG_TK_EP1_DZ" , "LandRover_Special_CZ_EP1_DZE" , "LandRover_Special_CZ_EP1_DZ" , "Offroad_DSHKM_Gue_DZE" , "Offroad_DSHKM_Gue_DZ" , "hilux1_civil_1_open" , "hilux1_civil_3_open_EP1" , "hilux1_civil_3_open" , "LandRover_CZ_EP1" , "LandRover_TK_CIV_EP1" , "BAF_Offroad_D" , "BAF_Offroad_W" , "LandRover_MG_TK_EP1" , "LandRover_MG_TK_EP1_DZ" , "LandRover_MG_TK_INS_EP1"  , "LandRover_Special_CZ_EP1" , "LandRover_Special_CZ_EP1_DZ" , "LandRover_SPG9_TK_EP1" , "LandRover_SPG9_TK_INS_EP1" , "LandRover_MG_TK_EP1" , "LandRover_MG_TK_EP1_DZ" , "LandRover_MG_TK_INS_EP1" , "LandRover_Special_CZ_EP1" , "LandRover_Special_CZ_EP1_DZ" , "LandRover_SPG9_TK_EP1" , "LandRover_SPG9_TK_INS_EP1" , "Offroad_DSHKM_Gue" , "Offroad_DSHKM_Gue_DZ" , "Offroad_DSHKM_Gue_DZE1" , "Offroad_DSHKM_Gue_DZE2" , "Offroad_DSHKM_Gue_DZE3" , "Offroad_DSHKM_Gue_DZE4" , "Offroad_DSHKM_INS" , "Offroad_DSHKM_TK_GUE_EP1"  , "Offroad_SPG9_Gue" , "Offroad_SPG9_TK_GUE_EP1" , 
                           "car_sedan" , "GLT_M300_LT" , "GLT_M300_ST" , "LadaLM" , "Skoda" , "SkodaBlue" , "SkodaGreen" , "SkodaRed" , "VolhaLimo_TK_CIV_EP1" , "Volha_1_TK_CIV_EP1" , "Volha_2_TK_CIV_EP1" , "VWGolf" , "car_hatchback" , "Lada1" , "Lada1_TK_CIV_EP1" , "Lada2" , "Lada2_TK_CIV_EP1" , "datsun1_civil_2_covered" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "Pickup_PK_TK_GUE_EP1_DZ" , "S1203_ambulance_EP1" , "S1203_TK_CIV_EP1" , "UAZ_CDF" , "UAZ_INS" , "UAZ_MG_TK_EP1_DZE" , "UAZ_MG_TK_EP1_DZ" , "UAZ_RU" , "UAZ_Unarmed_TK_CIV_EP1" , "UAZ_Unarmed_TK_EP1" , "UAZ_Unarmed_UN_EP1" , "datsun1_civil_1_open" , "datsun1_civil_3_open" , "Lada1_GDR" , "Lada2_GDR" , "Lada4_GDR" , "Lada5_GDR" , "Lada_base" , "Pickup_PK_GUE" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_INS" , "Pickup_PK_INS_DZ" , "Pickup_PK_INS_DZE" , "Pickup_PK_TK_GUE_EP1" , "Pickup_PK_TK_GUE_EP1_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "UAZ_AGS30_CDF" , "UAZ_AGS30_INS" , "UAZ_AGS30_RU" , "UAZ_AGS30_TK_EP1" , "UAZ_MG_CDF" , "UAZ_MG_INS" , "UAZ_MG_INS_DZ_LM" , "UAZ_MG_INS_DZ_VLM" , "UAZ_MG_CDF" , "UAZ_MG_CDF_DZ_LM" , "UAZ_MG_CDF_DZ_VLM" , "UAZ_MG_TK_EP1" , "UAZ_MG_TK_EP1_DZ" , "UAZ_SPG9_INS" , 
                           "ATV_CZ_EP1" , "ATV_US_EP1" , "CSJ_GyroC" , "CSJ_GyroCover" , "CSJ_GyroP" , "JetSkiYanahui_Case_Blue" , "JetSkiYanahui_Case_Green" , "JetSkiYanahui_Case_Red" , "JetSkiYanahui_Case_Yellow" , "BAF_ATV_D" , "BAF_ATV_W" , 
                           "M1030_US_DES_EP1" , "TT650_Civ" , "TT650_Ins" , "TT650_TK_CIV_EP1" , "M1030" , "TT650_Gue" , "TT650_TK_EP1" ,
                           "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];

// transportables that load onto transports types H1 or H2 -- medium trucks and smaller
gblTransportableTypesH1 = [ "hilux1_civil_2_covered" , "LandRover_MG_TK_EP1_DZE" , "LandRover_MG_TK_EP1_DZ" , "LandRover_Special_CZ_EP1_DZE" , "LandRover_Special_CZ_EP1_DZ" , "Offroad_DSHKM_Gue_DZE" , "Offroad_DSHKM_Gue_DZ" , "hilux1_civil_1_open" , "hilux1_civil_3_open_EP1" , "hilux1_civil_3_open" , "LandRover_CZ_EP1" , "LandRover_TK_CIV_EP1" , "BAF_Offroad_D" , "BAF_Offroad_W" , "LandRover_MG_TK_EP1" , "LandRover_MG_TK_EP1_DZ" , "LandRover_MG_TK_INS_EP1"  , "LandRover_Special_CZ_EP1" , "LandRover_Special_CZ_EP1_DZ" , "LandRover_SPG9_TK_EP1" , "LandRover_SPG9_TK_INS_EP1" , "LandRover_MG_TK_EP1" , "LandRover_MG_TK_EP1_DZ" , "LandRover_MG_TK_INS_EP1" , "LandRover_Special_CZ_EP1" , "LandRover_Special_CZ_EP1_DZ" , "LandRover_SPG9_TK_EP1" , "LandRover_SPG9_TK_INS_EP1" , "Offroad_DSHKM_Gue" , "Offroad_DSHKM_Gue_DZ" , "Offroad_DSHKM_Gue_DZE1" , "Offroad_DSHKM_Gue_DZE2" , "Offroad_DSHKM_Gue_DZE3" , "Offroad_DSHKM_Gue_DZE4" , "Offroad_DSHKM_INS" , "Offroad_DSHKM_TK_GUE_EP1"  , "Offroad_SPG9_Gue" , "Offroad_SPG9_TK_GUE_EP1" , 
                           "car_sedan" , "GLT_M300_LT" , "GLT_M300_ST" , "LadaLM" , "Skoda" , "SkodaBlue" , "SkodaGreen" , "SkodaRed" , "VolhaLimo_TK_CIV_EP1" , "Volha_1_TK_CIV_EP1" , "Volha_2_TK_CIV_EP1" , "VWGolf" , "car_hatchback" , "Lada1" , "Lada1_TK_CIV_EP1" , "Lada2" , "Lada2_TK_CIV_EP1" , "datsun1_civil_2_covered" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "Pickup_PK_TK_GUE_EP1_DZ" , "S1203_ambulance_EP1" , "S1203_TK_CIV_EP1" , "UAZ_CDF" , "UAZ_INS" , "UAZ_MG_TK_EP1_DZE" , "UAZ_MG_TK_EP1_DZ" , "UAZ_RU" , "UAZ_Unarmed_TK_CIV_EP1" , "UAZ_Unarmed_TK_EP1" , "UAZ_Unarmed_UN_EP1" , "datsun1_civil_1_open" , "datsun1_civil_3_open" , "Lada1_GDR" , "Lada2_GDR" , "Lada4_GDR" , "Lada5_GDR" , "Lada_base" , "Pickup_PK_GUE" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_INS" , "Pickup_PK_INS_DZ" , "Pickup_PK_INS_DZE" , "Pickup_PK_TK_GUE_EP1" , "Pickup_PK_TK_GUE_EP1_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "UAZ_AGS30_CDF" , "UAZ_AGS30_INS" , "UAZ_AGS30_RU" , "UAZ_AGS30_TK_EP1" , "UAZ_MG_CDF" , "UAZ_MG_INS" , "UAZ_MG_INS_DZ_LM" , "UAZ_MG_INS_DZ_VLM" , "UAZ_MG_CDF" , "UAZ_MG_CDF_DZ_LM" , "UAZ_MG_CDF_DZ_VLM" , "UAZ_MG_TK_EP1" , "UAZ_MG_TK_EP1_DZ" , "UAZ_SPG9_INS" , 
                           "ATV_CZ_EP1" , "ATV_US_EP1" , "CSJ_GyroC" , "CSJ_GyroCover" , "CSJ_GyroP" , "JetSkiYanahui_Case_Blue" , "JetSkiYanahui_Case_Green" , "JetSkiYanahui_Case_Red" , "JetSkiYanahui_Case_Yellow" , "BAF_ATV_D" , "BAF_ATV_W" , 
                           "M1030_US_DES_EP1" , "TT650_Civ" , "TT650_Ins" , "TT650_TK_CIV_EP1" , "M1030" , "TT650_Gue" , "TT650_TK_EP1" ,
                           "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];

// transportables that load onto transports types 0, H1, or H2 - light and small cars and trucks and smaller
gblTransportableTypes0 = [ "car_sedan" , "GLT_M300_LT" , "GLT_M300_ST" , "LadaLM" , "Skoda" , "SkodaBlue" , "SkodaGreen" , "SkodaRed" , "VolhaLimo_TK_CIV_EP1" , "Volha_1_TK_CIV_EP1" , "Volha_2_TK_CIV_EP1" , "VWGolf" , "car_hatchback" , "Lada1" , "Lada1_TK_CIV_EP1" , "Lada2" , "Lada2_TK_CIV_EP1" , "datsun1_civil_2_covered" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "Pickup_PK_TK_GUE_EP1_DZ" , "S1203_ambulance_EP1" , "S1203_TK_CIV_EP1" , "UAZ_CDF" , "UAZ_INS" , "UAZ_MG_TK_EP1_DZE" , "UAZ_MG_TK_EP1_DZ" , "UAZ_RU" , "UAZ_Unarmed_TK_CIV_EP1" , "UAZ_Unarmed_TK_EP1" , "UAZ_Unarmed_UN_EP1" , "datsun1_civil_1_open" , "datsun1_civil_3_open" , "Lada1_GDR" , "Lada2_GDR" , "Lada4_GDR" , "Lada5_GDR" , "Lada_base" , "Pickup_PK_GUE" , "Pickup_PK_GUE_DZE" , "Pickup_PK_GUE_DZ" , "Pickup_PK_INS" , "Pickup_PK_INS_DZ" , "Pickup_PK_INS_DZE" , "Pickup_PK_TK_GUE_EP1" , "Pickup_PK_TK_GUE_EP1_DZ" , "Pickup_PK_TK_GUE_EP1_DZE" , "UAZ_AGS30_CDF" , "UAZ_AGS30_INS" , "UAZ_AGS30_RU" , "UAZ_AGS30_TK_EP1" , "UAZ_MG_CDF" , "UAZ_MG_INS" , "UAZ_MG_INS_DZ_LM" , "UAZ_MG_INS_DZ_VLM" , "UAZ_MG_CDF" , "UAZ_MG_CDF_DZ_LM" , "UAZ_MG_CDF_DZ_VLM" , "UAZ_MG_TK_EP1" , "UAZ_MG_TK_EP1_DZ" , "UAZ_SPG9_INS" , 
                           "ATV_CZ_EP1" , "ATV_US_EP1" , "CSJ_GyroC" , "CSJ_GyroCover" , "CSJ_GyroP" , "JetSkiYanahui_Case_Blue" , "JetSkiYanahui_Case_Green" , "JetSkiYanahui_Case_Red" , "JetSkiYanahui_Case_Yellow" , "BAF_ATV_D" , "BAF_ATV_W" , 
                           "M1030_US_DES_EP1" , "TT650_Civ" , "TT650_Ins" , "TT650_TK_CIV_EP1" , "M1030" , "TT650_Gue" , "TT650_TK_EP1" ,
                           "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];

// transportables that load onto transport types A, O, H1, or H2 - small vehicles like ATVs, gyrocopters, or jetskis and smaller
gblTransportableTypesA = [ "ATV_CZ_EP1" , "ATV_US_EP1" , "CSJ_GyroC" , "CSJ_GyroCover" , "CSJ_GyroP" , "JetSkiYanahui_Case_Blue" , "JetSkiYanahui_Case_Green" , "JetSkiYanahui_Case_Red" , "JetSkiYanahui_Case_Yellow" , "BAF_ATV_D" , "BAF_ATV_W" , 
                           "M1030_US_DES_EP1" , "TT650_Civ" , "TT650_Ins" , "TT650_TK_CIV_EP1" , "M1030" , "TT650_Gue" , "TT650_TK_EP1" ,
                           "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];

// transportables that can fit onto transports types B, A, O, H1, or H2 - motorbikes and smaller
gblTransportableTypesB = [ "M1030_US_DES_EP1" , "TT650_Civ" , "TT650_Ins" , "TT650_TK_CIV_EP1" , "M1030" , "TT650_Gue" , "TT650_TK_EP1" ,
                           "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];

// transportables that can fit onto transports types C , B , A, 0, H1, or H2 - bicycles
gblTransportableTypesC = [ "Old_bike_TK_INS_EP1" , "MMT_Civ" , "MMT_USMC" , "Old_bike_TK_CIV_EP1" , "Old_moto_TK_Civ_EP1" ];



gblObjLastTransportCursorTarget = objNull;

gblTransportPlayerRemoveActions = [];

gblListTransportOptionFlags = [ 0 , 0 ];

gblbPlayerTransportControl = 0;

// the list of all vehicles being transported, game-wide

gblTransportedVehicles = [];

// the list of all vehicles transporting other vehicles, game-wide

gblTransportingVehicles = [];

// the list of all x coords where vehicles have been stashed way off map...

gblTransportingStashedCoordsX = [];

// the list of all y coords where vehicles have been stashed way off map...

gblTransportingStashedCoordsY = [];




// a list of skins that might be useful later
// AllPlayers = ["Survivor2_DZ","SurvivorWcombat_DZ","SurvivorWdesert_DZ","SurvivorWurban_DZ","SurvivorWsequishaD_DZ","SurvivorWsequisha_DZ","SurvivorWpink_DZ","SurvivorW3_DZ","SurvivorW2_DZ","Bandit1_DZ","Bandit2_DZ","BanditW1_DZ","BanditW2_DZ","Soldier_Crew_PMC","Sniper1_DZ","Camo1_DZ","Soldier1_DZ","Rocket_DZ","Rocker1_DZ","Rocker2_DZ","Rocker3_DZ","Rocker4_DZ","Priest_DZ","Functionary1_EP1_DZ","GUE_Commander_DZ","Ins_Soldier_GL_DZ","Haris_Press_EP1_DZ","Pilot_EP1_DZ","RU_Policeman_DZ","pz_policeman","pz_suit1","pz_suit2","pz_worker1","pz_worker2","pz_worker3","pz_doctor","pz_teacher","pz_hunter","pz_villager1","pz_villager2","pz_villager3","pz_priest","Soldier_TL_PMC_DZ","Soldier_Sniper_PMC_DZ","Soldier_Bodyguard_AA12_PMC_DZ","Drake_Light_DZ","CZ_Special_Forces_GL_DES_EP1_DZ","TK_INS_Soldier_EP1_DZ","TK_INS_Warlord_EP1_DZ","FR_OHara_DZ","FR_Rodriguez_DZ","CZ_Soldier_Sniper_EP1_DZ","Graves_Light_DZ","GUE_Soldier_MG_DZ","GUE_Soldier_Sniper_DZ","GUE_Soldier_Crew_DZ","GUE_Soldier_CO_DZ","GUE_Soldier_2_DZ","TK_Special_Forces_MG_EP1_DZ","TK_Soldier_Sniper_EP1_DZ","TK_Commander_EP1_DZ","RU_Soldier_Crew_DZ","INS_Lopotev_DZ","INS_Soldier_AR_DZ","INS_Soldier_CO_DZ","INS_Bardak_DZ","INS_Worker2_DZ"];

// might need to override this list of fuel trucks later -- can't remember if this is the list I modified ....
// DZE_fueltruckarray = ["KamazRefuel","KamazRefuel_DZ","UralRefuel_TK_EP1_DZ","MtvrRefuel_DES_EP1_DZ","V3S_Refuel_TK_GUE_EP1_DZ","MtvrRefuel_DZ","KamazRefuel_DZE","UralRefuel_TK_EP1_DZE","MtvrRefuel_DES_EP1_DZE","V3S_Refuel_TK_GUE_EP1_DZE","MtvrRefuel_DZE","UralRefuel_CDF"];

