private ["_array","_vehicle","_part","_hitpoint","_type","_isOK","_brokenPart","_cancel","_started","_finished"
	,"_hasToolbox" , "_nameType" , "_namePart" , "_animState" , "_isMedic" ,  "_pctChance" , 
	"_damage","_BreakableParts","_selection","_wpn","_classname","_ismelee"];


if (dayz_salvageInProgress) exitWith { localize "str_salvage_inprogress" call dayz_rollingMessages; };
dayz_salvageInProgress = true;


// get the array of parameters
_array = _this select 3;

// break out the values from the array
_vehicle = _array select 0;
_part =	_array select 1;
_hitpoint = _array select 2;

// find the type of vehicle
_type = typeOf _vehicle; 

// set defaults for OK to continue and part broken flags
_isOK = false;
_brokenPart = false;


// set up the damage value and the pct chance to salvage for each part type


// initialize _pctChance
_pctChance = 10;

if ( _part == "PartGlass" ) then {
    _damVal = 1;
    _pctChance = 62;
};

if ( _part == "PartWheel" ) then {
    _damVal = 1;
    _pctChance = 42;
};

if ( _part == "PartEngine" ) then {
    _damVal = 0.8;
    _pctChance = 67;
};

if ( _part == "PartFueltank" ) then {
    _damVal = 0.8;
    _pctChance = 67;
};

if ( _part == "PartVRotor" ) then {
    _damVal = 1;
    _pctChance = 33;
};


//

_hasToolbox = "ItemToolbox" in items player;

// moving this here because we need to know which part needed if we don't have it
_nameType = getText(configFile >> "cfgVehicles" >> _type >> "displayName");
_namePart = getText(configFile >> "cfgMagazines" >> _part >> "displayName");

// remove the salvage option from the menu
{_vehicle removeAction _x} count s_player_repairActions;
s_player_repairActions = [];

// reset the menu display control variable
s_player_repair_crtl = 1;


// init variables
_started = false;
_finished = false;
_cancel = false;


// if we have a toolbox, continue ...
if (_hasToolbox) then {

	// Added Nutrition-Factor for work
	["Working",0,[20,40,15,0]] call dayz_NutritionSystem;

	// check to see if we're in a safe zone -- if so, bag out
	{
		if ((_vehicle distance (_x select 0)) < (_x select 1)) exitWith {_cancel = true;};
	} count DZE_SafeZonePosArray;
	if ( _cancel ) exitWith { (localize "str_salvage_safezone") call dayz_rollingMessages;};

	// do a little dance
	player playActionNow "Medic";


	// play the shop sounds
	playSound "oggratchet01";    
	sleep 1;
	playSound "ogghammer01";
	sleep 2;
	playSound "oggratchet01";
	sleep 1;
	playSound "ogghammer01";
	sleep 2;


	// check to see if you injure yourself!
	if ( random 21 < 1 ) then {

		// subtract player blood -- client side
		r_player_blood = r_player_blood - ( r_player_bloodTotal * 0.15 * random 1 );

		// set player blood to local value -- server side
		player setVariable ["USEC_BloodQty", r_player_blood, true];

		playSound "oggdroptools01";
		cutText [ "You injured yourself!", "PLAIN DOWN" ];
		sleep 2;

	};


      // make some noise and attract zeds
	[player,"repair",0,false] call dayz_zombieSpeak;
	[player,50,true,(getPosATL player)] call player_alertZombies;


     // control vars for waiting through the animation
	r_interrupt = false;
	_animState = animationState player;
	r_doLoop = true;
	
	while {r_doLoop} do {

		_animState = animationState player;
		_isMedic = ["medic",_animState] call fnc_inString;
		if (_isMedic) then { _started = true; };
		if (_started and !_isMedic) then { r_doLoop = false; _finished = true; };
		if (r_interrupt) then { r_doLoop = false; };
		uiSleep 0.1;
	};

	r_doLoop = false;

     	// the chunk of code that actually does the salvage...
	if ( _finished ) then {

		//Remove melee magazines (BIS_fnc_invAdd fix)
		false call dz_fn_meleeMagazines;

           // find the damage value here for the selected part -- _damage will be between 0 and 1 where 1 is destroyed
		_damage = [_vehicle,_hitpoint] call object_getHit;

           // don't allow removal of completely obliterated parts

		if ( _damage < 1 ) then {

   	             	// first, look for attempts to double-remove engines or fuel systems -- and blow the vehicle up!
   	             	// if this is either an engine or a fuel system AND the existing damage is greater than 0.79, will ALWAYS fail!

			if ( ( ( _part == "PartEngine" ) || ( _part == "PartFueltank" ) ) && ( _damage > 0.79 ) ) then {

                    	  _damVal = 1;
                    	  _isOK = true;
                    	  _brokenPart = true;

			} else {

				// _findPercent = 0 to _pctChance -- so AT BEST an 80% chance of successful salvage!
				_findPercent = ( 1 - _damage ) * _pctChance;
			
				if( ( random 100 ) < _findPercent ) then {

					_isOK = [player,_part] call BIS_fnc_invAdd;
					_brokenPart = false;

				} else {

					_isOK = true;
					_brokenPart = true;

				};

			};
			
                // if we have space to add this part to inventory OR if the part is broken, do this stuff
			if ( _isOK ) then {

				// break the part
				_selection = getText(configFile >> "cfgVehicles" >> _type >> "HitPoints" >> _hitpoint >> "name");

				[_vehicle, _selection, 1] call fnc_veh_handleDam;

				_vehicle call fnc_veh_ResetEH;
//				_vehicle setvelocity [0,0,1];

				if(_brokenPart) then {

					// Failed!
					format[localize "str_salvage_destroyed",_namePart,_nameType] call dayz_rollingMessages;

				} else {

					// Success!
					format[localize "str_salvage_removed",_namePart,_nameType] call dayz_rollingMessages;
				};

			} else {

                     	// there's no room to hold the part inventory, AND we didn't break it...
				localize "str_player_24" call dayz_rollingMessages;
			};

		};

		true call dz_fn_meleeMagazines;

	} else {

		r_interrupt = false;

		if (vehicle player == player) then {
			[objNull, player, rSwitchMove,""] call RE;
			player playActionNow "stop";
		};

		localize "str_salvage_canceled" call dayz_rollingMessages;
	};
} else {

	format[localize "str_salvage_toolbox",_namePart] call dayz_rollingMessages;

};


dayz_myCursorTarget = objNull;
s_player_repair_crtl = -1;
dayz_salvageInProgress = false;


//adding melee mags back if needed
_wpn = primaryWeapon player;

//diag_log format["Classname: %1, WPN: %2", _classname,_wpn];
_ismelee = (getNumber (configFile >> "CfgWeapons" >> _wpn >> "melee") == 1);
if (_ismelee) then {
	call dayz_meleeMagazineCheck;
};