private ["_part","_color","_vehicle","_PlayerNear","_hitpoints","_isATV","_is6WheelType","_HasNoGlassKind",
	"_6WheelTypeArray","_NoGlassArray","_NoExtraWheelsArray","_RemovedPartsArray","_percent","_setAllSixWheelers",
	"_damage","_cmpt","_configVeh","_damagePercent","_string","_handle","_cancel","_type"];

_vehicle = _this select 3;

{dayz_myCursorTarget removeAction _x} count s_player_repairActions;
s_player_repairActions = [];

_PlayerNear = {isPlayer _x} count ((getPosATL _vehicle) nearEntities ["CAManBase", 10]) > 1;
if (_PlayerNear) exitWith {dayz_myCursorTarget = objNull; localize "str_pickup_limit_5" call dayz_rollingMessages;};

dayz_myCursorTarget = _vehicle;
_hitpoints = _vehicle call vehicle_getHitpoints;

_type = typeOf _vehicle;

_isATV = _type in ["ATV_US_EP1","ATV_CZ_EP1"];

_setAllSixWheelers = [
	"Kamaz_DZE" ,
	"KamazOpen_DZE" ,
	"KamazRefuel" ,
	"KamazRefuel_DZ" ,
	"KamazReammo" ,
	"KamazRepair" ,
	"MtvrRefuel_DES_EP1_DZ" ,
	"MTVR_DES_EP1" ,
	"MtvrReammo_DES_EP1" ,
	"MtvrRepair_DES_EP1" ,
	"MtvrSalvage_DES_EP1" ,
	"MtvrSupply_DES_EP1" ,
	"UralCivil_DZE" ,
	"UralCivil2_DZE" ,
	"UralRefuel_TK_EP1_DZ" ,
	"Ural_CDF" ,
	"Ural_TK_CIV_EP1" ,
	"Ural_UN_EP1" ,
	"UralReammo_CDF" ,
	"UralRefuel_CDF" ,
	"UralRepair_CDF" ,
	"UralSalvage_TK_EP1" ,
	"UralSupply_TK_EP1" ,
	"V3S_Open_TK_CIV_EP1" ,
	"V3S_Open_TK_EP1" ,
	"V3S_Refuel_TK_GUE_EP1_DZ" ,
	"V3S_TK_EP1_DZE" ,
	"V3S_Reammo_TK_GUE_EP1" ,
	"V3S_Repair_TK_GUE_EP1" ,
	"V3S_Salvage_TK_GUE_EP1" ,
	"V3S_Supply_TK_GUE_EP1" ,
	"WarfareReammoTruck_USMC" ,
	"WarfareRepairTruck_Gue" , 
	"WarfareSalvageTruck_USMC" ,
	"WarfareSupplyTruck_USMC"
];

_is6WheelType = _type in _setAllSixWheelers;

_setAllEightWheelers = [
	"BTR60_TK_EP1",
	"BTR90",
	"BTR90_HQ",
	"LAV25",
	"LAV25_HQ",
	"M1126_ICV_M2_EP1",
	"M1126_ICV_mk19_EP1",
	"M1128_MGS_EP1",
	"M1129_MC_EP1",
	"M1130_CV_EP1",
	"M1135_ATGMV_EP1",
	"MAZ_543_SCUD_TK_EP1"
];

_is8WheelType = _type in _setAllEightWheelers;


//_is6WheelType = false;
//{
//	if ( _type isKindOf _x ) exitWith { _is6WheelType = true; };
//} count ["Kamaz_Base","MTVR","Ural_Base","Ural_Base_withTurret","V3S_Base"];

_HasNoGlassKind = (_vehicle isKindOf "Motorcycle");

_6WheelTypeArray = ["HitLMWheel","HitRMWheel"];

_8WheelTypeArray = ["HitLF2Wheel","HitRF2Wheel"];

_NoGlassArray = ["HitGlass1","HitGlass2","HitGlass3","HitGlass4","HitGlass5","HitGlass6","HitLGlass","HitRGlass"];

//_NoExtraWheelsArray = ["wheel_1_4_steering","wheel_2_4_steering","wheel_1_3_steering","wheel_2_3_steering"];

//_RemovedPartsArray = ["motor","HitLF2Wheel","HitRF2Wheel","HitBody","HitMissiles","HitHull","HitVRotor","HitFuel","HitEngine"];


if ( _isATV or _HasNoGlassKind ) then {
	_hitpoints = _hitpoints - _NoGlassArray;
};

if ( _vehicle isKindOf "tractor" ) then {
	_hitpoints = _hitpoints - ["motor","HitLFWheel","HitRFWheel","HitLBWheel","HitRBWheel","HitLF2Wheel","HitRF2Wheel","HitLMWheel","HitRMWheel"];
};

if ( _vehicle isKindOf "Motocycle" ) then {
	_hitpoints = _hitpoints - ["HitEngine","HitFuel"];
};

// if the vehicle is a 6 wheeler ....
if ( _is6WheelType ) then {

	// add into the array the two hit entries for 6 wheelers
	_hitpoints = _hitpoints + _6WheelTypeArray;

} else {

	// it's NOT a 6 wheeler... but does it have EIGHT?
	if ( _is8WheelType ) then {

		// yes, so add into the hit array the FOUR entries for eight wheelers
		_hitpoints = _hitpoints + _8WheelTypeArray;

	} else {

		// neither -- subtract the hit values for 8 wheelers, just in case
		_hitpoints = _hitpoints - _8WheelTypeArray;

	};
};


// diag_log format["DEBUG SALVAGE: %1", _hitpoints];
{			
	_damage = [_vehicle,_x] call object_getHit;
	_part = "PartGeneric";

	//change "HitPart" to " - Part" rather than complicated string replace
	_cmpt = toArray (_x);
	_cmpt set [0,20];
	_cmpt set [1,toArray ("-") select 0];
	_cmpt set [2,20];
	_cmpt = toString _cmpt;
	
	if(["Engine",_x,false] call fnc_inString) then {
		_part = "PartEngine";
	};
		
	if(["HRotor",_x,false] call fnc_inString) then {
		_part = "PartVRotor"; 
	};

	if(["Fuel",_x,false] call fnc_inString) then {
		_part = "PartFueltank";
	};

	if(["Wheel",_x,false] call fnc_inString) then {
		_part = "PartWheel";
	};	
		
	if(["Glass",_x,false] call fnc_inString) then {
		_part = "PartGlass";
	};

	// allow removal of any lightly damaged parts
	if (_damage < 1 && _damage > 0) then {
		
		// Do not allow removal of scrap metal
		if (  _part == "PartGlass" || _part == "PartWheel" || _part == "PartEngine" || _part == "PartFueltank" || _part == "PartVRotor" ) then {

			_color = "color='#ffff00'"; //yellow
			if (_damage >= 0.5) then {_color = "color='#ff8800'";}; //orange
			if (_damage >= 0.9) then {_color = "color='#ff0000'";}; //red

			_percent = round(_damage*100);
			_string = format["<t %2>Remove%1 (%3 %4)</t>",_cmpt,_color,_percent,"%"]; //Remove - Part
			_handle = dayz_myCursorTarget addAction [_string, "overrides\salvage.sqf",[_vehicle,_part,_x], 0, false, true, "",""];
			s_player_repairActions set [count s_player_repairActions,_handle];
			
		};
	};

} count _hitpoints;

if ( count _hitpoints > 0 ) then {

	// Localized in A2OA\Expansion\dta\languagecore
	_cancel = dayz_myCursorTarget addAction [localize "str_action_cancel_action", "\z\addons\dayz_code\actions\repair_cancel.sqf","repair", 0, true, false];
	s_player_repairActions set [count s_player_repairActions,_cancel];
	s_player_repair_crtl = 1;
};